package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.jg.biz.core.BaseService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgFactoryInfoService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgFactoryInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 安全追溯-制造信息服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgFactoryInfoServiceImpl extends BaseService<IdxBizJgFactoryInfoMapper, IdxBizJgFactoryInfo> implements IIdxBizJgFactoryInfoService {

    public boolean saveOrUpdateData(IdxBizJgFactoryInfo factoryInfo) {
        return super.saveOrUpdateWithNull(factoryInfo);
    }

    @Override
    public IdxBizJgFactoryInfo getOneData(String record) {
        return this.getOne(new QueryWrapper<IdxBizJgFactoryInfo>().eq("RECORD", record));
    }

    @Override
    public boolean saveOrUpdateBatch(List<IdxBizJgFactoryInfo> factoryInfoList) {
        return super.saveOrUpdateBatch(factoryInfoList);
    }

    @Override
    public void updateBatchByRecord(List<IdxBizJgFactoryInfo> toUpdateFactoryInfoList) {
        toUpdateFactoryInfoList.forEach(info -> super.update(info, new LambdaUpdateWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, info.getRecord())));
    }
}