package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.CommonEquipDataProcessService;
import com.yeejoin.amos.boot.module.jg.biz.event.publisher.EventPublisher;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

@Component
@RequiredArgsConstructor
public class SingleManageEquipEditHandleImpl {
    private final CommonEquipDataProcessService commonEquipDataProcessService;

    private final EventPublisher publisher;

    public static final String BIZ_TYPE = "singleManageEquipEdit";

    public Map<String, ?> getDetail(String applyNo, String bizId) {
        return this.getDetailByBizId(bizId);
    }

    public Map<String, Object> getDetailByBizId(String record) {
        Map<String, Object> re = new HashMap<>();
        // 注册信息(基本信息)构建
        EquipRegisterChangeDataDto equipRegisterChangeDataDto = commonEquipDataProcessService.buildRegisterInfo(record);
        // 制造信息构建
        EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.buildFactoryInfo(record);
        // 设计信息构建
        EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.buildDesignInfo(record);
        // 使用信息
        EquipUseInfoChangeDataDto equipUseInfoChangeDataDto = commonEquipDataProcessService.buildUseInfo(record);
        re.putAll(BeanUtil.beanToMap(equipRegisterChangeDataDto));
        re.putAll(BeanUtil.beanToMap(factoryChangeDataDto));
        re.putAll(BeanUtil.beanToMap(designChangeDataDto));
        re.putAll(BeanUtil.beanToMap(equipUseInfoChangeDataDto));
        commonEquipDataProcessService.castJsonFields(re);
        return commonEquipDataProcessService.cast2UnderCase(re);
    }


    @Transactional(rollbackFor = Exception.class)
    public void doSave(String record, Map<String, Object> changeData, ReginParams selectedOrgInfo) {
        List<FieldChangeMeta> allChangeColumns = this.update(record, changeData);
        // 记录流水
        if (!allChangeColumns.isEmpty()) {
            // 异步记录变更流水
            publishEvent2Logger(record, allChangeColumns, selectedOrgInfo);
        }
    }

    private void publishEvent2Logger(String record, List<FieldChangeMeta> allChangeColumns, ReginParams selectedOrgInfo) {
        BizRelationDataDto relationDataDto = new BizRelationDataDto();
        relationDataDto.setBizId(record);
        relationDataDto.setRecords(new HashSet<>(Collections.singletonList(record)));
        relationDataDto.setChangeReason("西安数据编辑");
        relationDataDto.setProjectContraptionIds(new HashSet<>());
        relationDataDto.setRecUserName(selectedOrgInfo.getUserModel().getRealName());
        relationDataDto.setUnitCode(selectedOrgInfo.getCompany().getCompanyCode());
        relationDataDto.setUnitName(selectedOrgInfo.getCompany().getCompanyName());
        relationDataDto.setBizIsFinished(true);
        relationDataDto.setBizType(BusinessTypeEnum.JG_NEW_EQUIP.name());
        // 异步记录日志
        publisher.publish(new BaseBizDataChangeEvent(this, relationDataDto, allChangeColumns, RequestContext.cloneRequestContext()));
    }


    private List<FieldChangeMeta> update(String record, Map<String, Object> changeData) {
        List<FieldChangeMeta> allChangeColumns = new ArrayList<>();
        // 新数据解析
        EquipRegisterChangeDataDto registerChangeDataDto = CommonEquipDataProcessService.castMap2Bean(changeData, EquipRegisterChangeDataDto.class);
        EquipFactoryChangeDataDto factoryChangeDataDto = CommonEquipDataProcessService.castMap2Bean(changeData, EquipFactoryChangeDataDto.class);
        EquipDesignChangeDataDto designChangeDataDto = CommonEquipDataProcessService.castMap2Bean(changeData, EquipDesignChangeDataDto.class);
        EquipUseInfoChangeDataDto useInfoChangeDataDto = CommonEquipDataProcessService.castMap2Bean(changeData, EquipUseInfoChangeDataDto.class);
        commonEquipDataProcessService.buildChangeFields(record, designChangeDataDto, factoryChangeDataDto, registerChangeDataDto, null, useInfoChangeDataDto, allChangeColumns);
        // 前置校验
        commonEquipDataProcessService.checkValidField(record, registerChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        commonEquipDataProcessService.checkValidField(record, factoryChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        commonEquipDataProcessService.checkValidField(record, designChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        // 设备制造、设计、注册、使用信息业务处理落库
        commonEquipDataProcessService.dealBizDataForEquip(record, registerChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, factoryChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, designChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, useInfoChangeDataDto);
        return allChangeColumns;
    }
}
