package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.HisDataHandlerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@RequestMapping(value = "/hisDataHandler")
@Api(tags = "检验检测历史数据处理")
public class HisDataHandlerController {

    private final HisDataHandlerServiceImpl hisDataHandlerService;

    public HisDataHandlerController(HisDataHandlerServiceImpl hisDataHandlerService) {
        this.hisDataHandlerService = hisDataHandlerService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "压力管道批量报检，报检单据历史数据处理")
    @PutMapping(value = "/v1/pieLine/data")
    public ResponseModel<Boolean> pieLineDataHandlerV1() {
        hisDataHandlerService.pieLineDataHandlerV1();
        return ResponseHelper.buildResponse(true);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "开通机构分类历史数据处理,补充机构分类到证表")
    @PutMapping(value = "/v1/open/data")
    public ResponseModel<Boolean> openDataHandlerV1() {
        hisDataHandlerService.openDataHandlerV1();
        return ResponseHelper.buildResponse(true);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/fixPipeLen")
    @ApiOperation(httpMethod = "PUT", value = "压力管道报检结果管道长度补充", notes = "压力管道报检结果管道长度补充")
    public ResponseModel<Long> pipeLenFix() {
        return ResponseHelper.buildResponse(hisDataHandlerService.pipeLenFix());
    }
}
