package com.yeejoin.amos.boot.module.jczs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 
 * <pre>
 * 平台单位等级枚举
 * </pre>
 *
 * @author tb
 * @date 2023-05-31
 */
@Getter
@AllArgsConstructor
public enum CompanyLevelEnum {

	HEADQUARTER("headquarter", "省级"),
	PREFECTURE_LEVEL("prefecture-level", "地市级"),
	COUNTY("county", "区县级"),
	ORGANIZATION("organization", "基层机构");

    private String code;
    private String name;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

	public static CompanyLevelEnum getEnum(String code) {
		for (CompanyLevelEnum status : CompanyLevelEnum.values()) {
			if (status.getCode().equals(code)) {
				return status;
			}
		}
		return null;
	}
}

