package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@Group(value = "jg_inspection_detection_info")
public class EquipInspectChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    @FieldDisplayDefine(value ="检验类型")
    private String inspectType;

    @FieldDisplayDefine(value ="检验机构名称")
    private String inspectOrgName;

    @FieldDisplayDefine(value ="检验报告", type = JSON.class)
    private String inspectReport;

    @FieldDisplayDefine(value ="检验日期")
    private Date inspectDate;

    @FieldDisplayDefine(value ="检验结论")
    private String inspectConclusion;

    @FieldDisplayDefine(value ="下次检验日期")
    private Date nextInspectDate;

    @FieldDisplayDefine(value ="检验机构统一信用代码")
    private String inspectOrgCode;

    @FieldDisplayDefine(value ="检验报告编号")
    private String inspectReportNo;

    @FieldDisplayDefine(value ="检验流水唯一主键",isExist = false)
    private String jySeq;
}
