package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-压力管道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_pipeline")
public class TechParamsPipelineChangeFieldDto extends BaseTechParamsFieldDto {


    @FieldDisplayDefine(value = "唯一标识", isExist = false)
    private String record;


    @FieldDisplayDefine(value = "管道名称（登记单元）")
    private String pipeName;


    @FieldDisplayDefine(value = "管道编号")
    private String pipelineNumber;


    @FieldDisplayDefine(value = "管道级别")
    private String deviceLevel;


    @FieldDisplayDefine(value = "公称直径")
    private String nominalDiameter;


    @FieldDisplayDefine(value = "公称壁厚")
    private String wallThickness;


    @FieldDisplayDefine(value = "管道长度")
    private Double pipeLength;


    @FieldDisplayDefine(value = "设计压力")
    private String pressure;


    @FieldDisplayDefine(value = "设计温度")
    private String temperature;


    @FieldDisplayDefine(value = "设计介质")
    private String medium;

    @FieldDisplayDefine(value = "工作压力")
    private String workPressure;

    @FieldDisplayDefine(value = "工作温度")
    private String workTemperature;


    @FieldDisplayDefine(value = "工作介质")
    private String workMedium;

    @FieldDisplayDefine(value = "备注")
    private String remarks;

}
