package com.yeejoin.amos.boot.module.jg.api.enums;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum EquipSourceEnum {
    jg_his("历史设备", "jg_his"),
    jg_his_black("历史设备(无登记证)", "jg_his_black"),
    jg("新设备", "jg");

    private final String name;

    private final String code;


    public static String getMessage(String code) {
        for (EquipSourceEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }

    public static Map<Integer,String> getName=new HashMap<>();
    public static Map<String,Integer> getCode=new HashMap<>();

    static {
        for (ConstructionEnum e : ConstructionEnum.values()){
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }

    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getDataSourceName(String dataSource) {
        if(StringUtils.isEmpty(dataSource)){
            return EquipSourceEnum.jg_his.getName();
        }
        if(EquipSourceEnum.jg.getCode().equals(dataSource) || (dataSource.startsWith(EquipSourceEnum.jg.getCode()) && !dataSource.startsWith(EquipSourceEnum.jg_his.getCode()))){
            return EquipSourceEnum.jg.getName();
        } else if(dataSource.startsWith(EquipSourceEnum.jg_his_black.getCode())){
            return EquipSourceEnum.jg_his_black.getName();
        } else {
            return EquipSourceEnum.jg_his.getName();
        }
    }
}
