package com.yeejoin.amos.boot.module.jg.biz.context;

import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author Administrator
 */
@Component
public class EquipDataProcessStrategyContext implements ApplicationContextAware {

    private static final Map<DefaultBizDataChangeHandler.ModelType, IEquipChangeDataProcessStrategy> dataProcessStrategyHashMap = new HashMap<>();


    public static IEquipChangeDataProcessStrategy getStrategy(DefaultBizDataChangeHandler.ModelType modelType) {
        return Optional.ofNullable(dataProcessStrategyHashMap.get(modelType)).orElseThrow(() -> new RuntimeException(String.format("not found %s type strategy", modelType)));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, IEquipChangeDataProcessStrategy> strategyBeans = applicationContext.getBeansOfType(IEquipChangeDataProcessStrategy.class);
        if (strategyBeans.isEmpty()) {
            return;
        }
        for (IEquipChangeDataProcessStrategy strategy : strategyBeans.values()) {
            dataProcessStrategyHashMap.put(strategy.canHandleMode(), strategy);
        }
    }
}
