package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.biz.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.BizDataChangeServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SingleManageEquipEditHandleImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@RequestMapping(value = "/data-change")
@Api(tags = "业务数据变化处理控制器")
@RequiredArgsConstructor
public class BizDataChangeController {


    private final BizDataChangeServiceImpl bizDataChangeService;

    private final SingleManageEquipEditHandleImpl singleManageEquipEditHandle;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/v1/singleManageEquipEdit/save")
    @ApiOperation(value = "业务数据变更保存--西安专用", httpMethod = "POST")
    public ResponseModel<String> save(@RequestParam String applyNo,
                                      @RequestBody RequestChangeData changeData) {
        singleManageEquipEditHandle.doSave(applyNo, changeData);
        return ResponseHelper.buildResponse("success");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v1/singleManageEquipEdit/detail")
    @ApiOperation(value = "查询可业务变更的字段及默认值--西安专用", httpMethod = "GET")
    public ResponseModel<Map<String, ?>> getDetailV1(@RequestParam(required = false) String applyNo,
                                                     @RequestParam(required = false) String bizId) {
        return ResponseHelper.buildResponse(singleManageEquipEditHandle.getDetail(applyNo, bizId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/v2/{bizType}/save")
    @ApiOperation(value = "编辑保存--通用", httpMethod = "POST")
    public ResponseModel<String> saveV2(@ApiParam(required = true, value = "单据编号") @RequestParam String applyNo,
                                        @ApiParam(required = true, value = "业务类型") @PathVariable String bizType,
                                        @RequestBody RequestChangeData changeData) {
        // 基础数据校验
        changeData.validated();
        bizDataChangeService.save(applyNo, bizType, changeData);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v2/{bizType}/detail")
    @ApiOperation(value = "查询可业务变更的字段及默认值--通用", httpMethod = "GET")
    public ResponseModel<Map<String, ?>> getDetailV2(@RequestParam(required = false) String applyNo,
                                                     @RequestParam(required = false) String bizId,
                                                     @PathVariable String bizType,
                                                     DefaultBizDataChangeHandler.ModelType model) {
        return ResponseHelper.buildResponse(bizDataChangeService.queryDetail(applyNo, bizType, model, bizId));
    }
}
