package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgOverDesignServiceLifeDto;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgOverDesignServiceLifeServiceImpl;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.yeejoin.amos.boot.module.jg.api.entity.JgOverDesignServiceLife;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author system_generator
 * @date 2025-03-06
 */
@RestController
@Api(tags = "超设计使用年限控制器")
@RequestMapping(value = "/jg-over-design-service-life")
public class JgOverDesignServiceLifeController extends BaseController {

    @Autowired
    private JgOverDesignServiceLifeServiceImpl jgOverDesignServiceLifeServiceImpl;
    @Autowired
    private RedisUtils redisUtils;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<Object> save(@RequestBody JSONObject map) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.saveOrUpdate(map, reginParams));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> delete(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.delete(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询详情
     *
     * @param sequenceNbr 主键
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getDetail")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询使用年限详情", notes = "根据sequenceNbr查询使用年限详情")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.getDetail(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.deleteBatchBySequenceNbrs(ids));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping("/getPageList")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<Map<String, Object>>> getPageList(@RequestParam("current") int current,
                                                                @RequestParam("size") int size,
                                                                @RequestParam(value = "sort", required = false) String sort,
                                                                JgOverDesignServiceLifeDto dto) {
        ReginParams reginParams = getSelectedOrgInfo();
        dto.setUnitCode(Optional.ofNullable(reginParams.getCompany().getCompanyCode())
                .map(code -> code.contains("_") ? code.split("_")[1] : code)
                .orElse(""));
        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            dto.setDataType(BaseController.COMPANY_TYPE_COMPANY);
        } else {
            dto.setDataType(BaseController.COMPANY_TYPE_SUPERVISION);
        }
        dto.setCurrentUserId(reginParams.getUserModel().getUserId());
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.getPageList(new Page<>(current, size), sort, dto));
    }

    /**
     * 撤回操作
     *
     * @param map map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "超设计使用年限撤回", notes = "撤回")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> cancel(@RequestBody JSONObject map) {
        jgOverDesignServiceLifeServiceImpl.cancel(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")),
                String.valueOf(map.getOrDefault("manageType", "")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 执行流程
     *
     * @param map map
     * @return ResponseModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "超设计使用年限执行流程", notes = "超设计使用年限执行流程")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
        jgOverDesignServiceLifeServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),
                String.valueOf(map.get("instanceId")),
                String.valueOf(map.get("operate")),
                String.valueOf(map.get("comment")),
                String.valueOf(map.get("nextTaskId")),
                String.valueOf(map.get("equDefineCode")));
        return ResponseHelper.buildResponse("ok");
    }

    /**
     * 超设计使用年限作废
     * @param dto
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "超设计使用年限作废", notes = "超设计使用年限作废")
    @PutMapping(value = "/invalid")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgOverDesignServiceLife> invalid(@RequestBody JgOverDesignServiceLifeDto dto) {
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.invalid(dto.getSequenceNbr(), dto.getCancelReason()));
    }

    /**
     * 获取最新检验信息详情
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getNewWTJYInspectionDetailByRecord")
    @ApiOperation(httpMethod = "GET", value = "获取最新检验信息详情", notes = "获取最新检验信息详情")
    public ResponseModel<Map<String, Object>> getNewWTJYInspectionDetailByRecord(@RequestParam("record") String record,
                                                                                 @RequestParam("equListCode") String equListCode) {
        return ResponseHelper.buildResponse(jgOverDesignServiceLifeServiceImpl.getNewWTJYInspectionDetailByRecord(record,equListCode));
    }
}
