package com.yeejoin.amos.boot.module.jg.biz.dto;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;


public class RequestChangeData extends JSONObject {

    /**
     * 批量编辑时表格key-公共使用
     */
    public static final String multiDataKey = "tableData";

    /**
     * 分类-用于匹配设备（包括装置）的数据处理器
     *
     * @see DefaultBizDataChangeHandler.ModelType
     */
    private static final String modelTypeKey = "modelType";

    /**
     * 删除的数据表格key-管道使用
     */
    public static final String deletedDataKey = "deleteData";

    /**
     * 变更说明
     */
    public static final String changeReasonKey = "changeReason";

    /**
     * 变更说明附件
     */
    public static final String changeReasonAttachmentKey = "changeReasonAttachment";

    public DefaultBizDataChangeHandler.ModelType getModelType() {
        if (this.containsKey(modelTypeKey)) {
            return DefaultBizDataChangeHandler.ModelType.valueOf(this.getString(modelTypeKey));
        }
        return null;
    }

    public void validated() {
        if (!this.containsKey(changeReasonKey) || !this.containsKey(changeReasonAttachmentKey)) {
            throw new BadRequest("变更说明和变更说明附件不能为空！");
        }
    }

}
