package com.yeejoin.amos.boot.module.jg.biz.edit;

import com.yeejoin.amos.boot.module.jg.biz.context.BizDataHandleStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service
public class BizDataChangeServiceImpl {


    /**
     * 变更保存
     *
     * @param applyNo    单据编号
     * @param bizType    业务类型
     * @param changeData 变化后的数据
     */
    @Transactional(rollbackFor = Exception.class)
    public void save(String applyNo,
                     String bizType,
                     RequestChangeData changeData) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        handleStrategy.doSave(applyNo, changeData.getModelType(), changeData);
    }

    public Map<String, ?> queryDetail(String applyNo, String bizType, DefaultBizDataChangeHandler.ModelType model, String bizId) {
        IBizDataChangeHandleStrategy handleStrategy = BizDataHandleStrategyContext.getStrategy(bizType);
        return handleStrategy.getDetail(applyNo, model, bizId);
    }

}
