package com.yeejoin.amos.boot.module.jg.biz.edit.core;

import com.yeejoin.amos.boot.module.jg.api.dto.BaseChangeDataDto;
import org.reflections.Reflections;

import java.util.HashSet;
import java.util.Set;

public class SubClassFinder {
    private static final Set<Class<? extends BaseChangeDataDto>> subClasses;

    static {
        //▼ 指定扫描包路径（根据实际项目调整）
        Reflections reflections = new Reflections("com.yeejoin.amos.boot.module.jg.api.dto");
        //▼ 获取所有继承BaseChangeDataDto的类
        subClasses = reflections.getSubTypesOf(BaseChangeDataDto.class);
    }

    public static Set<Class<? extends BaseChangeDataDto>> getAllSubClasses() {
        return new HashSet<>(subClasses);
    }
}
