package com.yeejoin.amos.boot.module.jg.biz.edit.event;

import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import lombok.Getter;
import org.typroject.tyboot.core.foundation.context.RequestContextModel;

import java.util.List;

/**
 * @author Administrator
 */
@Getter
public class ChangeLogInsertEvent extends BaseBizDataChangeEvent {

    private final List<ChangeDataDto> data;

    private final RequestContextModel requestContext;

    private String applyNo;

    private String bizType;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param source the object on which the event initially occurred or with
     *               which the event is associated (never {@code null})
     */
    public ChangeLogInsertEvent(Object source, List<ChangeDataDto> data, RequestContextModel requestContext) {
        super(source);
        this.data = data;
        this.requestContext = requestContext;
    }

    /**
     *
     * @param source  对象
     * @param applyNo 单据编号
     * @param bizType 业务类型（表名）
     * @param data    变化的数据
     * @param requestContext 上下文
     */
    public ChangeLogInsertEvent(Object source, String applyNo, String bizType, List<ChangeDataDto> data, RequestContextModel requestContext) {
        super(source);
        this.data = data;
        this.applyNo = applyNo;
        this.bizType = bizType;
        this.requestContext = requestContext;
    }


}
