package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz;

import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import com.yeejoin.amos.boot.module.jg.biz.edit.core.RouterEventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
public class UseRegisterDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {


    private final UseRegisterUpdateService useRegisterUpdateService;

    protected UseRegisterDataChangeHandler(RouterEventPublisher routerEventPublisher, UseRegisterUpdateService useRegisterUpdateService) {
        super(routerEventPublisher);
        this.useRegisterUpdateService = useRegisterUpdateService;
    }


    @Override
    public String canHandleBizType() {
        return "tzs_jg_use_registration";
    }


    /**
     * 保存
     *
     * @param applyNo    单据编号
     * @param model      single, batch
     * @param changeData 前端不支持分组-目前为平铺数据结构
     */
    @Override
    public List<ChangeDataDto> bizDataSave(String applyNo, ModelType model, Map<String, Object> changeData) {
        List<ChangeDataDto> bizEditColumns = new ArrayList<ChangeDataDto>();
        // 单据信息的保存、与设备相关、证相关字段的更新
        // 1.根据任务状态进行单据数据的处理
        // 1.1 流程中，更新业务相关字段、更新设备
        // 1.2 已完成，更新业务相关字段、证相关、批量方式的设备公共字段信息
        // 选择是台套、还是单位办理的方式，进行分类数据的解析
        // 更新历史的JSON的数据
        this.updateHistoryJson(applyNo);
        this.buildLogData(bizEditColumns);
        return bizEditColumns;
    }

    @Override
    public Boolean beforeCheck(String applyNo, ModelType model, Map<String, Object> changeData) {
        return true;
    }

    private void updateHistoryJson(String applyNo) {
        useRegisterUpdateService.updateHisData(applyNo);
    }

    private void buildLogData(List<ChangeDataDto> allChangeColumns) {
        allChangeColumns.forEach(column -> {
            column.setBizType("使用登记");
        });
    }


    @Override
    public Map<String, ?> getDetail(String applyNo, ModelType model, String bizId) {
        return null;
    }

    @Override
    protected BaseBizDataChangeEvent buildEvent(String applyNo, ModelType model, Map<String, Object> changeData) {
        return new BaseBizDataChangeEvent(this, applyNo, RequestContext.cloneRequestContext());
    }

}
