package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy;

import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;

import java.util.List;
import java.util.Map;

public interface IBizDataChangeHandleStrategy  {

    /**
     * 可处理的业务类型(使用登记等)
     *
     * @return 业务类型
     */
    String canHandleBizType();

    /**
     * 获取变更信息详情
     *
     * @param applyNo 单据编号
     * @param model   single, batch
     * @param bizId   设备record
     * @return 变更信息详情
     */
    Map<String, ?> getDetail(String applyNo, ModelType model, String bizId);

    /**
     * 保存
     * @param applyNo    单据编号
     * @param model      @see ModelType
     * @param changeData 变更数据
     */
    List<ChangeDataDto> bizDataSave(String applyNo, ModelType model, Map<String, Object> changeData);


    /**
     * 前置校验 如业务字段的重复性检验
     * @param applyNo 单据编号
     * @param model   类型
     * @param changeData 数据
     * @return 是否通过前置校验
     */
    Boolean beforeCheck(String applyNo, ModelType model, Map<String, Object> changeData);

    /**
     * 单据方式：单个处理、批量处理
     */
    enum ModelType {
        singleProject,
        batchProject,
        singleEquip,
        batchEquip,
        batchCylinder
    }

    void doSave(String applyNo, ModelType model, Map<String, Object> changeData) ;
}
