package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.biz.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 批量维护气瓶-策略实现类
 */
@Component
public class BatchCylinderDataEquipChangeProcess implements IEquipChangeDataProcessStrategy {

    private final CommonEquipDataProcessService commonEquipDataProcessService;


    public BatchCylinderDataEquipChangeProcess(CommonEquipDataProcessService commonEquipDataProcessService) {
        this.commonEquipDataProcessService = commonEquipDataProcessService;
    }


    @Override
    public List<ChangeDataDto> handle(Map<String, Object> changeData, String defaultChangeId) {
        JSONObject data = (JSONObject) changeData;
        JSONArray equips = data.getJSONArray(RequestChangeData.multiDataKey);
        List<ChangeDataDto> allChangeColumns = new ArrayList<>();
        List<MultiChangeItemData> items = equips.toJavaList(MultiChangeItemData.class);
        // 校验
        items.forEach(item -> {
            String record = item.getRecord();
            Map<String, Object> itemData = item.getDetail();
            if (itemData != null) {
                EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipRegisterChangeDataDto.class);
                EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipFactoryChangeDataDto.class);
                EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipDesignChangeDataDto.class);
                // 前置检验
                commonEquipDataProcessService.checkValidField(record, registerChangeDataDto, null, null, null);
                commonEquipDataProcessService.checkValidField(record, factoryChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
                commonEquipDataProcessService.checkValidField(record, designChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
            }
        });
        // 入库
        items.forEach(item -> {
            String record = item.getRecord();
            Map<String, Object> itemData = item.getDetail();
            if (itemData != null) {
                EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipRegisterChangeDataDto.class);
                EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipFactoryChangeDataDto.class);
                EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipDesignChangeDataDto.class);
                commonEquipDataProcessService.buildChangeFields(record, designChangeDataDto, factoryChangeDataDto, registerChangeDataDto, allChangeColumns);
                // 设备制造、设计、注册信息业务处理落库
                commonEquipDataProcessService.dealBizDataForEquip(record, registerChangeDataDto);
                commonEquipDataProcessService.dealBizDataForEquip(record, factoryChangeDataDto);
                commonEquipDataProcessService.dealBizDataForEquip(record, designChangeDataDto);
                // 设备技术参数入库处理
                commonEquipDataProcessService.updateTechParamInfo(registerChangeDataDto, record, itemData, allChangeColumns);
            }
        });
        return allChangeColumns;
    }

//    private void updateUseRegisterProjectInfo(JgUseRegistration jgUseRegistration, ProjectContraptionChangeDataDto projectContraptionChangeDataDto) {
//        LambdaUpdateWrapper<JgUseRegistration> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.eq(JgUseRegistration::getSequenceNbr, jgUseRegistration.getSequenceNbr());
//        updateWrapper.set(JgUseRegistration::getProjectContraption, projectContraptionChangeDataDto.getProjectContraption());
//        useRegistrationService.update(null, updateWrapper);
//    }
//
//    private void calTotalPieLineLength(ProjectContraptionChangeDataDto projectContraptionChangeDataDto, List<PipelineChangeItemDto> items) {
//        projectContraptionChangeDataDto.setPipelineLength(items.stream().filter(i -> i.getPipeLength() != null).mapToDouble(TechParamsPipelineChangeFieldDto::getPipeLength).sum());
//    }


//    public Map<String, Object> getDetail(String applyNo, String bizId) {
//        Map<String, Object> result = new HashMap<>();
//        JgUseRegistration jgUseRegistration = useRegistrationService.getOne(new LambdaQueryWrapper<JgUseRegistration>()
//                .eq(JgUseRegistration::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgUseRegistration::getProjectContraptionId));
//        LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
//        lambda.eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
//        lambda.select(JgUseRegistrationEq::getEquId);
//        List<JgUseRegistrationEq> eqs = useRegistrationEqService.getBaseMapper().selectList(lambda);
//        List<String> records = eqs.stream().map(JgUseRegistrationEq::getEquId).collect(toList());
//        IdxBizJgRegisterInfo registerInfo = useRegistrationService.getRegisterInfo(jgUseRegistration);
//        List<Map<String, Object>> tableData;
//        if (EquipmentClassifityEnum.YLGD.getCode().equals(registerInfo.getEquList())){
//            IdxBizJgProjectContraption idxBizJgProjectContraption = idxBizJgProjectContraptionService.getById(jgUseRegistration.getProjectContraptionId());
//            Map<String, Object> map = IdxBizJgRegisterInfoServiceImpl.convertCamelToUnderscore(idxBizJgProjectContraption, IdxBizJgProjectContraptionServiceImpl.jsonFields);
//            result.putAll(map);
//            result.put("projectContraptionId", idxBizJgProjectContraption.getSequenceNbr());
//            tableData = jgUseRegistrationMapper.queryForUnitPipelineEquipmentForEdit(records);
//        } else {
//            List<DictionarieValueModel> fillingMedium = Systemctl.dictionarieClient.dictValues("FILLING_MEDIUM").getResult();
//            Map<String, Object> fillingMediumMap = fillingMedium.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
//            tableData = jgUseRegistrationMapper.queryForUnitVesselEquipment(records);
//            tableData.forEach(i -> i.put("chargingMedium", fillingMediumMap.get(i.get("chargingMedium"))));
//        }
//        result.put("tableData", tableData);
//        return result;
//    }

//    private Map<String, Object> cast2UnderCase(Map<String, Object> re) {
//        // 由于历史遗留问题，和前端保存统一，要转成大写下滑线驼峰
//        Map<String, Object> result = new HashMap<>();
//        re.forEach((k, v) -> {
//            result.put(CharSequenceUtil.toUnderlineCase(k).toUpperCase(), v);
//        });
//        return result;
//    }


    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return DefaultBizDataChangeHandler.ModelType.batchCylinder;
    }
}
