package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.biz.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 批量维护设备-策略实现类
 */
@Component
public class BatchEquipDataEquipChangeProcess implements IEquipChangeDataProcessStrategy {

    private final CommonEquipDataProcessService commonEquipDataProcessService;


    public BatchEquipDataEquipChangeProcess(CommonEquipDataProcessService commonEquipDataProcessService) {
        this.commonEquipDataProcessService = commonEquipDataProcessService;
    }


    @Override
    public List<ChangeDataDto> handle(Map<String, Object> changeData, String defaultChangeId) {
        JSONObject data = (JSONObject) changeData;
        JSONArray equips = data.getJSONArray(RequestChangeData.multiDataKey);
        List<ChangeDataDto> allChangeColumns = new ArrayList<>();
        List<MultiChangeItemData> items = equips.toJavaList(MultiChangeItemData.class);
        // 校验
        items.forEach(item -> {
            String record = item.getRecord();
            Map<String, Object> itemData = item.getDetail();
            if (itemData != null) {
                EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipRegisterChangeDataDto.class);
                EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipFactoryChangeDataDto.class);
                EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipDesignChangeDataDto.class);
                // 前置检验
                commonEquipDataProcessService.checkValidField(record, registerChangeDataDto, null, null, null);
                commonEquipDataProcessService.checkValidField(record, factoryChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
                commonEquipDataProcessService.checkValidField(record, designChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
            }
        });
        // 入库
        items.forEach(item -> {
            String record = item.getRecord();
            Map<String, Object> itemData = item.getDetail();
            if (itemData != null) {
                EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipRegisterChangeDataDto.class);
                EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipFactoryChangeDataDto.class);
                EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(itemData, EquipDesignChangeDataDto.class);
                commonEquipDataProcessService.buildChangeFields(record, designChangeDataDto, factoryChangeDataDto, registerChangeDataDto, allChangeColumns);
                // 设备制造、设计、注册信息业务处理落库
                commonEquipDataProcessService.dealBizDataForEquip(record, registerChangeDataDto);
                commonEquipDataProcessService.dealBizDataForEquip(record, factoryChangeDataDto);
                commonEquipDataProcessService.dealBizDataForEquip(record, designChangeDataDto);
                // 设备技术参数入库处理
                commonEquipDataProcessService.updateTechParamInfo(registerChangeDataDto, record, itemData, allChangeColumns);
            }
        });
        return allChangeColumns;
    }


    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return DefaultBizDataChangeHandler.ModelType.batchEquip;
    }
}
