package com.yeejoin.amos.boot.module.jg.biz.edit.process.equip;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipDesignChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipFactoryChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipRegisterChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.strategy.IEquipChangeDataProcessStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 单个维护设备-策略实现类
 */
@Component
public class SingleEquipEquipChangeProcess implements IEquipChangeDataProcessStrategy {


    private final JgUseRegistrationServiceImpl useRegistrationService;

    private final JgUseRegistrationEqMapper jgRelationEquipMapper;

    private final CommonEquipDataProcessService commonEquipDataProcessService;


    public SingleEquipEquipChangeProcess(JgUseRegistrationServiceImpl useRegistrationService, JgUseRegistrationEqMapper jgRelationEquipMapper, CommonEquipDataProcessService commonEquipDataProcessService) {
        this.useRegistrationService = useRegistrationService;
        this.jgRelationEquipMapper = jgRelationEquipMapper;
        this.commonEquipDataProcessService = commonEquipDataProcessService;
    }


    @Override
    public List<ChangeDataDto> handle(Map<String, Object> changeData, String defaultChangeId) {
        String record = this.getRecord(defaultChangeId);
        List<ChangeDataDto> allChangeColumns = new ArrayList<>();
        // 新数据解析
        EquipRegisterChangeDataDto registerChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipRegisterChangeDataDto.class);
        EquipFactoryChangeDataDto factoryChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipFactoryChangeDataDto.class);
        EquipDesignChangeDataDto designChangeDataDto = commonEquipDataProcessService.castMap2Bean(changeData, EquipDesignChangeDataDto.class);
        commonEquipDataProcessService.buildChangeFields(record, designChangeDataDto, factoryChangeDataDto, registerChangeDataDto, allChangeColumns);
        // 前置校验
        commonEquipDataProcessService.checkValidField(record, registerChangeDataDto, null, null, null);
        commonEquipDataProcessService.checkValidField(record, factoryChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        commonEquipDataProcessService.checkValidField(record, designChangeDataDto, registerChangeDataDto.getEquList(), registerChangeDataDto.getEquCategory(), registerChangeDataDto.getEquDefine());
        // 设备制造、设计、注册信息业务处理落库
        commonEquipDataProcessService.dealBizDataForEquip(record, registerChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, factoryChangeDataDto);
        commonEquipDataProcessService.dealBizDataForEquip(record, designChangeDataDto);
        // 设备技术参数入库处理
        commonEquipDataProcessService.updateTechParamInfo(registerChangeDataDto, record, changeData, allChangeColumns);
        return allChangeColumns;
    }


    public String getRecord(String applyNo) {
        JgUseRegistration jgUseRegistration = useRegistrationService.getOne(new LambdaQueryWrapper<JgUseRegistration>()
                .eq(JgUseRegistration::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda()
                .eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr())
                .eq(JgUseRegistrationEq::getIsDelete, false).select(JgUseRegistrationEq::getEquId);
        JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
        return jgUseRegistrationEq.getEquId();
    }

    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return DefaultBizDataChangeHandler.ModelType.singleEquip;
    }

}
