package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.module.jyjc.api.enums.TopicEnum;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.UseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.component.rule.config.RuleConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.util.Arrays;
import java.util.List;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class RuleCommonServiceImpl {

    private UseInfoMapper useInfoMapper;

    private TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    private final EmqKeeper emqKeeper;

    /**
     * 特殊独立的区县
     */
    private static final String[] EXCLUSION_CITY_REGIONS = {"610403", "610581"};

    public RuleCommonServiceImpl(UseInfoMapper useInfoMapper, TzBaseEnterpriseInfoMapper enterpriseInfoMapper, EmqKeeper emqKeeper) {
        this.useInfoMapper = useInfoMapper;
        this.enterpriseInfoMapper = enterpriseInfoMapper;
        this.emqKeeper = emqKeeper;
    }


    String getArea(String record) {
        UseInfo equipUseInfo = useInfoMapper.selectOne(Wrappers.<UseInfo>lambdaQuery().select(UseInfo::getCity, UseInfo::getCounty).eq(UseInfo::getRecord, record));
        if (equipUseInfo == null) {
            return "";
        }
        // 特殊地区特殊处理，目前有韩城、杨凌,原因行政区划上是有层级的，但是业务办理时，他们与所在地市是同级别的
        if (StringUtils.isEmpty(equipUseInfo.getCity()) || StringUtils.isEmpty(equipUseInfo.getCounty())) {
            return "";
        }
        if (Arrays.asList(EXCLUSION_CITY_REGIONS).contains(equipUseInfo.getCounty())) {
            return equipUseInfo.getCounty();
        }
        return equipUseInfo.getCity();
    }


    public UseInfo getUseInfo(String record) {
        return useInfoMapper.selectOne(Wrappers.<UseInfo>lambdaQuery().select(UseInfo::getCity, UseInfo::getCounty).eq(UseInfo::getRecord, record));
    }

    public String getArea(UseInfo equipUseInfo) {
        if (equipUseInfo == null) {
            return "";
        }
        // 特殊地区特殊处理，目前有韩城、杨凌,原因行政区划上是有层级的，但是业务办理时，他们与所在地市是同级别的
        if (StringUtils.isEmpty(equipUseInfo.getCity()) || StringUtils.isEmpty(equipUseInfo.getCounty())) {
            return "";
        }
        if (Arrays.asList(EXCLUSION_CITY_REGIONS).contains(equipUseInfo.getCounty())) {
            return equipUseInfo.getCounty();
        }
        return equipUseInfo.getCity();
    }

    public String getCounty(UseInfo equipUseInfo) {
        if (equipUseInfo == null) {
            return "";
        }
        return equipUseInfo.getCounty();
    }

    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType) {
        return enterpriseInfoMapper.getInspectionUnitList(openBizType);
    }

    public void publishMqttMessage(String componentKey, Object message) throws MqttException {
        log.info("报检规则推送到web主题：{}:,消息内容为：{}", String.format(TopicEnum.INSPECTION_LIST_PUSH.getTopic(), componentKey), JSON.toJSONString(message));
        try {
            emqKeeper.getMqttClient().publish(String.format(TopicEnum.INSPECTION_LIST_PUSH.getTopic(), componentKey),
                    JSON.toJSONString(message).getBytes(), RuleConfig.DEFAULT_QOS, false);
        } catch (MqttException e) {
            log.error("Error publishing MQTT message: {}", e.getMessage());
            throw e;
        }
    }

    public void setIsCanNoAccept(List<TzBaseEnterpriseInfoDto> matchEnterpriseInfos, Boolean isCanNoAccept) {
        matchEnterpriseInfos.forEach(m -> {
            m.setUseCodeAndName(m.getUseCode() + "_" + isCanNoAccept);
        });
    }

}
