package com.yeejoin.amos.boot.module.tcm.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsTwoStaffingCompanyCheckDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsTwoStaffingCompanyDto;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsTwoStaffing;
import com.yeejoin.amos.boot.module.tcm.api.service.ITzsTwoStaffingService;
import com.yeejoin.amos.boot.module.tcm.api.vo.TzsTwoStaffingExportVo;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.TzsUserInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

;

@RestController
@Api(tags = "两员配备统计")
@RequestMapping(value = "/twoStaff")
public class TzsTwoStaffingController extends BaseController {
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";

    @Autowired
    private ITzsTwoStaffingService tzsTwoStaffingService;

    @Autowired
    private TzsUserInfoServiceImpl tzsUserInfoServiceImpl;

    @Autowired
    RedisUtils redisUtils;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCompanyList")
    @ApiOperation(httpMethod = "GET", value = "企业两员配备情况查询", notes = "企业两员配备情况查询")
    public ResponseModel<IPage<TzsTwoStaffingCompanyDto>> getCompanyList(@RequestParam(value = "orgCode") String orgCode,
                                                                         @RequestParam(value = "current") String current,
                                                                         @RequestParam(value = "size") String size,
                                                                         TzsTwoStaffingCompanyDto companyDto) {

        Page<TzsTwoStaffingCompanyDto> page = new Page<>();
        page.setCurrent(Long.parseLong(current));
        page.setSize(Long.parseLong(size));

        return ResponseHelper.buildResponse(tzsTwoStaffingService.getCompanyList(orgCode, companyDto,page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportCompanyData")
    @ApiOperation(httpMethod = "GET", value = "企业两员配备情况导出", notes = "企业两员配备情况导出")
    public void exportData(HttpServletResponse response,
                           @RequestParam(value = "orgCode") String orgCode,
                           TzsTwoStaffingCompanyDto dto) {
        Page<TzsTwoStaffingCompanyDto> page = new Page<>();
        page.setCurrent(1);
        page.setSize(Long.MAX_VALUE);
        List<TzsTwoStaffingCompanyDto> equipExportData = tzsTwoStaffingService.getCompanyList(orgCode, dto, page).getRecords();
        ExcelUtil.createTemplate(response, "企业两员配备情况", "企业两员配备情况", equipExportData, TzsTwoStaffingCompanyDto.class, null, false);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getStatisticsMessage")
    @ApiOperation(httpMethod = "GET", value = "监管单位统计信息", notes = "监管单位统计信息")
    public ResponseModel<Object> getStatisticsMessage(@RequestParam("sequenceNbr") String sequenceNbr,
                                                      @RequestParam("type") String type) {
        List<LinkedHashMap> data = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        ArrayList<LinkedHashMap> result = new ArrayList<>();
        List<LinkedHashMap> list = tzsUserInfoServiceImpl.screenData(result, data, sequenceNbr);
        Page<TzsTwoStaffing> tzsTwoStaffingPage = new Page<>();
        List<TzsTwoStaffing> statisticsMessage = tzsTwoStaffingService.getStatisticsMessage(list, type);
        tzsTwoStaffingPage.setRecords(statisticsMessage);
        if(CollUtil.isNotEmpty(statisticsMessage)){
            tzsTwoStaffingPage.setPages(1);
            tzsTwoStaffingPage.setTotal(statisticsMessage.size());
        }
        return ResponseHelper.buildResponse(tzsTwoStaffingPage);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/generateTwoStaffingStatistics")
    @ApiOperation(httpMethod = "GET", value = "生成两员配备统计", notes = "生成两员配备统计")
    public ResponseModel<Object> generateTwoStaffingStatistics() {
        tzsTwoStaffingService.generateTwoStaffingStatistics();
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/exportData")
    @ApiOperation(httpMethod = "GET", value = "监管单位统计信息导出", notes = "监管单位统计信息导出")
    public void exportData(HttpServletResponse response,
                           @RequestParam("sequenceNbr") String sequenceNbr,
                           @RequestParam("type") String type) {
        List<LinkedHashMap> data = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        ArrayList<LinkedHashMap> result = new ArrayList<>();
        List<LinkedHashMap> list = tzsUserInfoServiceImpl.screenData(result, data, sequenceNbr);
        List<TzsTwoStaffing> statisticsMessage = tzsTwoStaffingService.getStatisticsMessage(list, type);
        ArrayList<TzsTwoStaffingExportVo> exportVos = new ArrayList<>();
        for (TzsTwoStaffing tzsTwoStaffing : statisticsMessage) {
            TzsTwoStaffingExportVo vo = new TzsTwoStaffingExportVo();
            BeanUtil.copyProperties(tzsTwoStaffing, vo);
            exportVos.add(vo);
        }
        ExcelUtil.createTemplate(response, "监管单位统计信息", type, exportVos, TzsTwoStaffingExportVo.class, null, false);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCompanyCheckList")
    @ApiOperation(httpMethod = "GET", value = "企业排查情况查询", notes = "企业排查情况查询")
    public ResponseModel<IPage<TzsTwoStaffingCompanyCheckDto>> getCompanyCheckList(@RequestParam(value = "orgCode") String orgCode,
                                                                                   @RequestParam(value = "current") String current,
                                                                                   @RequestParam(value = "size") String size,
                                                                                   TzsTwoStaffingCompanyCheckDto companyDto) {

        Page<TzsTwoStaffingCompanyCheckDto> page = new Page<>();
        page.setCurrent(Long.parseLong(current));
        page.setSize(Long.parseLong(size));
        return ResponseHelper.buildResponse(tzsTwoStaffingService.getCompanyCheckList(orgCode, companyDto,page));
    }

}
