package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipTechParamPipeline;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
@Mapper
public interface EquipTechParamPipelineMapper extends BaseMapper<EquipTechParamPipeline> {
    /**
     * 在用的最新需求整理的技术参数--需求未出
     *
     * @param record 设备唯一标识
     * @return EquipTechParamVessel
     */
    EquipTechParamPipeline queryTechParamInUse(@Param("record") String record);

    /**
     * 统计压力管道长度
     *
     * @param orgCode 区域code对应的管辖机构
     * @return 数量
     */
    String sumPipeLengthByOrgCode(@Param("orgCode") String orgCode,@Param("supervisoryFlag") Boolean supervisoryFlag);
}
