package com.yeejoin.amos.latentdanger.common.enums;

import com.yeejoin.amos.boot.biz.common.utils.DynamicEnumUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @author DELL
 */
public enum LatentDangerLevelEnum {

    /**
     * 安全问题
     */
    安全问题("安全问题", "0", "0", 1),
    /**
     * 一般隐患
     */
    一般隐患("一般隐患", "1", "1", 2),
    /**
     * 重大隐患
     */
    重大隐患("重大隐患", "2", "2", 3);

    /**
     * 巡检枚举缓存
     */
    public static Map<String, LatentDangerLevelEnum> patrolDangerLevelEnumMap = new HashMap<>();

    static {
        LatentDangerLevelEnum[] initEnum = LatentDangerLevelEnum.values();
        for(LatentDangerLevelEnum _enum : initEnum) {
            patrolDangerLevelEnumMap.put(_enum.getCode(), _enum);
        }
    }

    /**
     * 枚举缓存
     */
    public static Map<String, LatentDangerLevelEnum> supervisionDangerLevelEnumMap = new HashMap<>();

    public static final String dictCode = "_DANGER_LEVEL";

    /**
     * 名称，描述
     */
    private String name;

    /**
     * 编码
     */
    private String code;

    /**
     * 风险源等级
     */
    private String riskSourceDangerLevelCode;

    /**
     * 排序
     */
    private Integer order;

//    static {
//        EnumSet<LatentDangerLevelEnum> set = EnumSet.allOf(LatentDangerLevelEnum.class);
//        for (LatentDangerLevelEnum each : set) {
//            // 增加一个缓存 减少对枚举的修改
//            enumMap.put(each.code, each);
//        }
//    }

    LatentDangerLevelEnum(String name, String code, String riskSourceDangerLevelCode, Integer order) {
        this.name = name;
        this.code = code;
        this.riskSourceDangerLevelCode = riskSourceDangerLevelCode;
        this.order = order;
    }

    public static LatentDangerLevelEnum getByRiskSourceDangerLevelCode(String riskSourceDangerLevelCode) {
        for (LatentDangerLevelEnum l : LatentDangerLevelEnum.values()) {
            if (riskSourceDangerLevelCode.equals(l.getRiskSourceDangerLevelCode())) {
                return l;
            }
        }
        return null;
    }

    public static LatentDangerLevelEnum getEnumByOrder(Integer order) {
        for (LatentDangerLevelEnum l : supervisionDangerLevelEnumMap.values()) {
            if (order.equals(l.getOrder())) {
                return l;
            }
        }
        return null;
    }

    /**
     * 根据关键字段获取枚举值  可以在这里做一些修改 来达到动态添加的效果
     *
     * @param code
     */
    public static LatentDangerLevelEnum getEnumByCode(String code) {
        // 这里可以做一些修改  比如若从 enumMap 中没有取得 则加载配置动态添加
        return supervisionDangerLevelEnumMap.get(code);
    }

    public static LatentDangerLevelEnum addEnumDynamic(String enumName, String name, String code,
                                                       String riskSourceDangerLevelCode, Integer order) {
        LatentDangerLevelEnum dangerLevelEnum = DynamicEnumUtil.addEnum(LatentDangerLevelEnum.class, enumName,
                new Class[]{String.class, String.class, String.class, Integer.class}, new Object[]{name, code,
                        riskSourceDangerLevelCode, order});
        if (!ValidationUtil.isEmpty(dangerLevelEnum)) {
            supervisionDangerLevelEnumMap.put(code, dangerLevelEnum);
        }
        return dangerLevelEnum;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRiskSourceDangerLevelCode() {
        return riskSourceDangerLevelCode;
    }

    public void setRiskSourceDangerLevelCode(String riskSourceDangerLevelCode) {
        this.riskSourceDangerLevelCode = riskSourceDangerLevelCode;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }
}
