package com.yeejoin.amos.maintenance.mqtt;

import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

/**
 * @author DELL
 */
@Component
@Slf4j
public class MqttGateway {
    @Autowired
    private EmqKeeper emqKeeper;

    public void publish(String topic, String jsonStr) {
        try {
            this.emqKeeper.getMqttClient().publish(topic, jsonStr.getBytes(), 1, false);
        } catch (MqttException e) {
            log.error("消息发送失败：{}、{}、{}", e.getMessage(), topic, jsonStr);
        }
    }
}
