package com.yeejoin.amos.boot.module.tzs.api.service;


import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.RegUnitInfoDto;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;

import java.util.Collection;
import java.util.List;

/**
 * 单位注册信息表接口类
 *
 * @author system_generator
 * @date 2022-08-09
 */
public interface IRegUnitInfoService {

    /**
     * 单位注册
     * @param model RegUnitInfoDto
     * @return RegUnitInfoDto
     */
    RegUnitInfoDto registerUnit(RegUnitInfoDto model);


    /**
     * 单位校验
     * @param unitCode 单位唯一编号
     * @param unitType 单位类型
     * @return RegUnitInfoDto
     */
    RegUnitInfoDto unitCheck(String unitCode, String unitType);

    /**
     * 单位类型列表字典
     * @return List<DataDictionary>
     */
    List<DataDictionary> getUnitTypeList();

    /**
     * 获取管辖机构树
     * @return 组织架构中单位级别为：省级、地市级、区县级的单位
     */
    Collection getManagementUnitTree();

    /**
     * 单位注销
     * @param unitCode 单位唯一标识
     * @return 是否成功
     */
    Boolean unitLogOut(String unitCode);
}
