package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum EquipTypeEnum {
    elevator("elevator","","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamElevator","com.yeejoin.amos.api.openapi.face.service.EquipTechParamElevatorService"),
    lifting("lifting","safetyProtectionDevice,mainPart","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamLifting","com.yeejoin.amos.api.openapi.face.service.EquipTechParamLiftingService"),
    vehicle("vehicle","mainParts","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamVehicle","com.yeejoin.amos.api.openapi.face.service.EquipTechParamVehicleService"),
    ropeway("ropeway","mainComponents","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamRopeway","com.yeejoin.amos.api.openapi.face.service.EquipTechParamRopewayService"),
    rides("rides","","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamRides","com.yeejoin.amos.api.openapi.face.service.EquipTechParamRidesService"),
    boiler("boiler","safetyAccessoriesAndRelatedDevices","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamBoiler","com.yeejoin.amos.api.openapi.face.service.EquipTechParamBoilerService"),
    vessel("vessel","fixedSafetyAccessory,gasCylinder,gasCylinderAccessories","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamVessel","com.yeejoin.amos.api.openapi.face.service.EquipTechParamVesselService"),
    pipeline("pipeline","pipeInfo","com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamPipeline","com.yeejoin.amos.api.openapi.face.service.EquipTechParamPipelineService");

    String type;
    String fileNames;
    String classPath;
    String servicePath;


    public static Map<String,String> classPathmap = new HashMap<>();
    public static Map<String,String> servicePathmap = new HashMap<>();
    public static Map<String,String> serviceFileListmap = new HashMap<>();

    static {
        for(EquipTypeEnum e: EquipTypeEnum.values()){
            classPathmap.put(e.type, e.classPath);
            servicePathmap.put(e.type, e.servicePath);
            serviceFileListmap.put(e.type,e.fileNames);
        }
    }
}
