package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@Group(value = "equip_design_info")
public class EquipDesignChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "设计单位统一社会信用代码")
    private String designUnitCreditCode;

    @FieldDisplayDefine(value = "设计单位名称")
    private String designUnitName;

    @FieldDisplayDefine(value = "设计许可编号")
    private String designLicenseNum;

    @FieldDisplayDefine(value = "设计使用年限")
    private String designUseDate;

    @FieldDisplayDefine(value = "设计日期")
    private String designDate;

    @FieldDisplayDefine(value = "总图图号")
    private String drawingDo;

    @FieldDisplayDefine(value = "设计文件", type = JSON.class)
    private String designDoc;

    @FieldDisplayDefine(value = "设计文件鉴定单位")
    private String appraisalUnit;

    @FieldDisplayDefine(value = "设计文件鉴定日期")
    private String appraisalDate;

    @FieldDisplayDefine(value = "设计规范", type = JSON.class)
    private String designStandard;

    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessoriesDes;

    @FieldDisplayDefine(value = "设计资料是否完整齐全")
    private String designIsComplete;
}
