package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 设备移交
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_equip_transfer")
public class JgEquipTransfer extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请状态
     */
	@TableField("apply_status")
    private String applyStatus;

    /**
     * 申请日期
     */
	@TableField("apply_date")
    private Date applyDate;

    /**
     * 施工单位统一信用代码
     */
	@TableField("install_unit_credit_code")
    private String installUnitCreditCode;

    /**
     * 施工单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 设备数量
     */
	@TableField("equip_num")
    private Integer equipNum;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id 
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 流程状态
     */
	@TableField("instance_status")
    private String instanceStatus;

    /**
     * 受理完成日期
     */
	@TableField("accept_date")
    private Date acceptDate;

    /**
     * 下一执行节点ids
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;

    /**
     * 任务发起人id
     */
    @TableField(value = "promoter")
    private String promoter;

    /**
     * 任务发起人id
     */
    @TableField(value = "task_name")
    private String taskName;

    /**
     * 任务发起人id
     */
    @TableField(value = "instance_roles")
    private String instanceRoles;

    @TableField(exist = false)
    private String processAdvice;

    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;

    @TableField(value = "create_user_company_name")
    private String createUserCompanyName;

    /**
     * 设备监管码
     */
    @TableField(exist = false)
    private String supervisoryCode;

    /**
     * 设备类别
     */
    @TableField(exist = false)
    private String equCategory;

    /**
     * 设备品种
     */
    @TableField(exist = false)
    private String equDefine;

    /**
     * 设备出厂编号
     */
    @TableField(exist = false)
    private String factoryNum;

    /**
     * 设备注册代码
     */
    @TableField(exist = false)
    private String equCode;

    /**
     * 使用登记证编号
     */
    @TableField(exist = false)
    private String useRegistCode;

    /**
     * 地址
     */
    @TableField(exist = false)
    private String equAddress;

    /**
     * 设备名称
     */
    @TableField(exist = false)
    private String productName;

    /**
     * 内部编号
     */
    @TableField(exist = false)
    private String useInnerCode;

    /**
     * 下一节点可执行人逗号分割
     */
    @TableField(value = "next_execute_user_ids")
    private String nextExecuteUserIds;

    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 设备种类
     */
    @TableField(value = "equ_list")
    private String equList;

    /**
     * 设备种类Code
     */
    @TableField(value = "equ_list_code")
    private String equListCode;

    /**
     * 工程装置表seq--压力管道用
     */
    @TableField(value = "project_contraption_seq")
    private String projectContraptionSeq;
}
