package com.yeejoin.amos.boot.module.ys.biz.feign;


import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.VerifyCodeAuthModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@FeignClient(value = "AMOS-API-PRIVILEGE", configuration = {FeignConfiguration.class})
public interface PrivilegeFeginService {

    @RequestMapping(value = "/privilege/v1/agencyuser/me", method = RequestMethod.GET)
    ResponseModel<AgencyUserModel> getMe();

    //获取单位树
    @RequestMapping(value = "/privilege/v1/company/tree", method = RequestMethod.GET)
    FeignClientResult tree(@RequestHeader("token") String token, @RequestHeader("appKey") String appKey, @RequestHeader("product") String product);

    @RequestMapping(value = {"/privilege/v1/company/tree/cache"}, method = {RequestMethod.GET})
    FeignClientResult queryAgencyTreeForCache(@RequestHeader("token") String token, @RequestHeader("appKey") String appKey, @RequestHeader("product") String product) throws InnerInvokException;


    //获取省级行政区划
    @RequestMapping(value = "systemctl/v1/region/level", method = RequestMethod.GET)
    FeignClientResult getProvince(@RequestParam String level);

    //获取行政区划树
    @RequestMapping(value = "systemctl/v1/region/tree", method = RequestMethod.GET)
    FeignClientResult getTree();

    /**
     * 手机号验证码登录
     */
    @RequestMapping(value = "/privilege/v1/auth/mobile/verifycode", method = RequestMethod.POST)
    FeignClientResult mobileVerifyCode(@RequestBody VerifyCodeAuthModel model) throws InnerInvokException;



    @RequestMapping(value = "/privilege/v1/agencyuser/list/company/{companyId}", method = RequestMethod.GET)
    FeignClientResult getCompanyUser(@PathVariable(value = "companyId")Long companyId);



}
