package com.yeejoin.amos.fas.business.controller;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.service.intfc.EquipmentSpecificIndexService;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * @ProjectName: YeeAmosFireAutoSysRoot
 * @Package: com.yeejoin.amos.fas.business.controller
 * @ClassName: EquipmentSpecificIndexController
 * @Author: Jianqiang Gao
 * @Description: EquipmentSpecificIndexController
 * @Date: 2021/1/18 16:32
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/api/equipSpecificIndex")
@Api(tags = "装备性能指标Api")
public class EquipmentSpecificIndexController extends AbstractBaseController {

    @Value("${autoSys.alarm.nameKeys}")
    private String nameKeys;

    @Value("${autoSys.alarm.status}")
    private String status;

    @Value("${autoSys.alarm.value}")
    private String value;

    @Autowired
    private EquipmentSpecificIndexService equipmentSpecificIndexService;

    @Permission
    @ApiOperation(httpMethod = "GET", value = "获取最新告警状态", notes = "获取最新告警状态")
    @RequestMapping(value = "/queryInitAlarm", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryInitAlerm(@ApiParam(value = "物联采集属性值", required = true) @RequestParam String value,
                                         @ApiParam(value = "多nameKey，中间英文逗号隔开", required = true) @RequestParam String nameKeys,
                                         @ApiParam(value = "多status，中间英文逗号隔开", required = true) @RequestParam String status) {

        return CommonResponseUtil.success(equipmentSpecificIndexService.queryInitAlarm(value, nameKeys, status));
    }

    @Permission
    @ApiOperation(httpMethod = "GET", value = "获取三维初始化告警信息", notes = "获取三维初始化告警信息")
    @RequestMapping(value = "/getInitAlarm", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse getInitAlarm(@ApiParam(value = "物联采集属性值") @RequestParam(required = false) String value,
                                       @ApiParam(value = "多nameKey，中间英文逗号隔开") @RequestParam(required = false) String nameKeys,
                                       @ApiParam(value = "多status，中间英文逗号隔开") @RequestParam(required = false) String status) {
        if (!StringUtils.isNotBlank(value) && !StringUtils.isNotBlank(nameKeys) && !StringUtils.isNotBlank(status)) {
            value = this.value;
            nameKeys = this.nameKeys;
            status = this.status;
        }
        return CommonResponseUtil.success(equipmentSpecificIndexService.getInitAlarm(value, nameKeys, status));
    }

}