package com.yeejoin.amos.boot.module.elevator.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertMaintenanceUnitStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertMsgDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.elevator.api.dto.AlertUseUnitStatisticsDto;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.DPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/db/statistics")
@Api(tags = "大屏统计")
public class DPStatisticsController {


    private DPStatisticsServiceImpl statisticsService;

    public DPStatisticsController(DPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-办理量 (近7日)", notes = "大屏-应急-办理量 (近7日)")
    @PostMapping(value = "/yj/eventStatByDay")
    public ResponseModel<JSONObject> eventStatByDay(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByDay(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-电梯数量统计 (按区域)", notes = "大屏-应急-电梯数量统计 (按区域)")
    @PostMapping(value = "/yj/elevatorCountStat")
    public ResponseModel<JSONObject> elevatorCountStat(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.elevatorCountStat(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-事件分布 (按场所)", notes = "大屏-应急-事件分布 (按场所)")
    @PostMapping(value = "/yj/eventStatByLocation")
    public ResponseModel<JSONObject> eventStatByLocation(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByLocation(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-困人救援月度情况", notes = "大屏-应急-困人救援月度情况")
    @PostMapping(value = "/yj/trappedUserCount")
    public ResponseModel<JSONObject> trappedUserCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情列表", notes = "大屏-应急-即时警情列表")
    @PostMapping(value = "/yj/instantAlert")
    public ResponseModel<List<AlertPaperInfoDto>> instantAlert(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.instantAlert(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-月度困人故障高发使用单位", notes = "大屏-应急-月度困人故障高发使用单位")
    @PostMapping(value = "/yj/trappedUserHighCompanyCount")
    public ResponseModel<List<AlertUseUnitStatisticsDto>> trappedUserHighCompanyCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserHighCompanyCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名", notes = "大屏-应急-维保单位平均救援时间排名")
    @PostMapping(value = "/yj/rankUnitByRescueTime")
    public ResponseModel<List<AlertMaintenanceUnitStatisticsDto>> rankUnitByRescueTime(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTime(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-各地市应急事件总数排名", notes = "大屏-应急-各地市应急事件总数排名")
    @PostMapping(value = "/yj/regionEventRank")
    public ResponseModel<JSONObject> regionEventRank(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.regionEventRank(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图图列统计", notes = "大屏-应急-中间地图图列统计")
    @PostMapping(value = "/yj/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/yj/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }
}
