package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgMaintenanceRecordInfoService;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgMaintenanceRecordInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgMaintenanceRecordInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgMaintenanceRecordInfoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 安全追溯-维保备案信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgMaintenanceRecordInfoServiceImpl extends BaseService<IdxBizJgMaintenanceRecordInfoDto,IdxBizJgMaintenanceRecordInfo,IdxBizJgMaintenanceRecordInfoMapper> implements IIdxBizJgMaintenanceRecordInfoService {

    public boolean saveOrUpdateData(IdxBizJgMaintenanceRecordInfo maintenanceRecordInfo){
        return this.saveOrUpdate(maintenanceRecordInfo);
    }

    //查询最新的记录
    public IdxBizJgMaintenanceRecordInfo queryNewestDetailByRecord(String record) {
        IdxBizJgMaintenanceRecordInfo result = new IdxBizJgMaintenanceRecordInfo();
        QueryWrapper<IdxBizJgMaintenanceRecordInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(IdxBizJgMaintenanceRecordInfo::getRecord,record).orderByDesc(IdxBizJgMaintenanceRecordInfo::getInformEnd);
        List<IdxBizJgMaintenanceRecordInfo> maintenanceRecordInfoList = list(queryWrapper);
        if(!ValidationUtil.isEmpty(maintenanceRecordInfoList)){
            BeanUtils.copyProperties(maintenanceRecordInfoList.get(0),result);
        }
        return result;
    }


}