package com.yeejoin.amos.boot.module.tcm.biz.controller.statistics.dp;

import com.yeejoin.amos.boot.module.tcm.api.dto.ScreenDto;
import com.yeejoin.amos.boot.module.tcm.api.service.statistics.IScreenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 大屏控制层
 *
 * @author maxy
 * @date 2024-07-09
 */
@RestController
@Api(tags = "大屏企业统计")
@RequestMapping(value = "/statistics")
public class ScreenController {
    @Resource
    private IScreenService screenService;
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/companyInfo")
    @ApiOperation(httpMethod = "POST", value = "大屏企业统计", notes = "大屏企业统计")
    public ResponseModel<List<Map<String,Object>>> companyInfo(@RequestBody ScreenDto screenDto){
        return ResponseHelper.buildResponse(screenService.companyInfo(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/testOrg")
    @ApiOperation(httpMethod = "POST", value = "大屏检测机构统计", notes = "大屏检测机构统计")
    public ResponseModel<List<Map<String,Object>>> testOrg(@RequestBody ScreenDto screenDto){
        return ResponseHelper.buildResponse(screenService.testOrg(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/userCount")
    @ApiOperation(httpMethod = "POST", value = "大屏人员统计", notes = "大屏人员统计")
    public ResponseModel<Map<String,Object>> userCount(@RequestBody ScreenDto screenDto){
        return ResponseHelper.buildResponse(screenService.userCount(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/supervisorCount")
    @ApiOperation(httpMethod = "POST", value = "大屏行业主管部门统计", notes = "大屏行业主管部门统计")
    public ResponseModel<Map<String,Object>> supervisorCount(@RequestBody ScreenDto screenDto){
        return ResponseHelper.buildResponse(screenService.supervisorCount(screenDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/equipmentInformCount")
    @ApiOperation(httpMethod = "POST", value = "大屏设备使用场所统计", notes = "大屏设备使用场所统计")
    public ResponseModel<List<Map<String,Object>>> equipmentInformCount(@RequestBody ScreenDto screenDto){
        return ResponseHelper.buildResponse(screenService.equipmentInformCount(screenDto));
    }
}
