package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 标签处理器处理器
 */
@Component("tagTypeHandler")
public class TagTypeHandler implements TypeHandler<String> {
    private static final Map<String, String> CODE_NAME_MAP = new HashMap<String, String>();

    static {
        CODE_NAME_MAP.put("1", "A类");
        CODE_NAME_MAP.put("2", "B类");
    }

    @Override
    public String handle(String value) {
        return CODE_NAME_MAP.get(value);
    }
}
