package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Component
public class UseRegistrationStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgUseRegistrationServiceImpl jgUseRegistrationServiceImpl;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Object> notice = jgUseRegistrationServiceImpl.getDetail("", sequenceNbr, reginParams);
        Map<String, Object> basic = new HashMap<>();
        Map<String, Object> useRegFormUpload = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.SYDJ.getBusinessCode());
        basic.put("businessScenarios", "0");
        basic.put("receiveOrgCreditCode1", notice.get("receiveOrgCode"));
        basic.put("code", notice.get("EQU_LIST_CODE"));
        basic.put("equCategory", notice.get("EQU_CATEGORY_CODE"));
        basic.put("isTempEquip", true);
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", notice);
        result.put("basic", basic);
        useRegFormUpload.put("uploadMode", Objects.toString(notice.get("uploadMode"),"2"));
        useRegFormUpload.put("useRegistrationFormUrl", notice.get("useRegistrationFormUrl"));
        result.put("useRegFormUpload", useRegFormUpload);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_USAGE_REGISTRATION.getName();
    }
}
