package com.yeejoin.amos.boot.module.ys.biz.feign;


import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(name = "TZS-YMT", path = "/ymt", configuration =
        {FeignConfiguration.class})
public interface TzsServiceFeignClient {


    /**
     * 创建监管码及96333
     *
     * @param map 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/createSupervisorCode", method = RequestMethod.POST)
    ResponseModel<Map<String, Object>> createCode(@RequestBody Map<String, Object> map);

    /**
     * 创建监管码及96333
     *
     * @param paramMap 请求体
     * @return
     */
    @RequestMapping(value = "/equipment-category/commonUpdateEsData", method = RequestMethod.POST)
    ResponseModel<Map<String, Object>> commonUpdateEsDataByIds(@RequestBody Map<String, Map<String, Object>> paramMap);


    /**
     * 申请单编号生成
     * @param type 参考ApplicationFormTypeEnum中的枚举
     * @param batchSize batchSize
     * @return List
     */
    @RequestMapping(value = "/generate-code/applicationFormCode", method = RequestMethod.POST)
    ResponseModel<List<String>> applicationFormCode(@RequestParam("type") String type,
                                                    @RequestParam("batchSize") int batchSize);

    /**
     * 生成设备注册编码
     * @param key 16位
     * @return 生成设备注册编码(20位)
     */
    @RequestMapping(value = "/generate-code/deviceRegistrationCode", method = RequestMethod.POST)
    ResponseModel<String> deviceRegistrationCode(@RequestParam("key") String key);

    /**
     * 使用登记证生成
     * @param key 起11陕C
     * @return 生成使用登记证编号(13位，起11陕C00001(23))
     */
    @RequestMapping(value = "/generate-code/useRegistrationCode", method = RequestMethod.POST)
    ResponseModel<String> useRegistrationCode(@RequestParam("key") String key);


}
