package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.core.framework.PersonIdentify;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.boot.module.common.api.enums.OrgPersonEnum;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireStationServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;


/**
 * 微型消防站
 *
 * @author system_generator
 * @date 2021-06-28
 */
@RestController
@Api(tags = "微型消防站Api")
    @RequestMapping(value = "/common/fire-station")
public class FireStationController extends BaseController {

    @Autowired
    FireStationServiceImpl fireStationServiceImpl;

    @Autowired
    OrgUsrServiceImpl iOrgUsrService;

    @Value("${auth-key-fire-station:fire_station_info}")
    private String authKey;

    /**
     * 新增微型消防站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增微型消防站", notes = "新增微型消防站")
    public ResponseModel<FireStationDto> save(@RequestBody FireStationDto model) {
        model = fireStationServiceImpl.add(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新微型消防站", notes = "根据sequenceNbr更新微型消防站")
    public ResponseModel<FireStationDto> updateBySequenceNbrFireStation(@RequestBody FireStationDto model,
                                                                        @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(fireStationServiceImpl.Update(model));
    }

    /**
     *  根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除微型消防站", notes = "根据sequenceNbr删除微型消防站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.updateisDelete(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个微型消防站", notes = "根据sequenceNbr查询单个微型消防站")
    public ResponseModel<FireStationDto> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "微型消防站分页查询", notes = "微型消防站分页查询")
    public ResponseModel<Page<FireStationDto>> queryForPage(@RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size,String bizOrgCode) {
        Page<FireStationDto> page = new Page<FireStationDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryForFireStationPage(page,bizOrgCode));
    }

    /**
     * 新列表分页查询
     *
     * @param pageNum 当前页
     * @param pageSize 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list/page")
    @ApiOperation(httpMethod = "GET", value = "新微型消防站分页查询", notes = "新微型消防站分页查询")
    public ResponseModel<Page<FireStationDto>> getFireStation(@RequestParam(value = "pageNum") int pageNum,
                                                              @RequestParam(value = "pageSize") int pageSize,@RequestParam(value = "company",required = false) Long company,
                                                              FireStationDto fireStationDto) {
        if (company != null && company != -1){
            fireStationDto.setBizCompanyId(company);
        }
        return ResponseHelper.buildResponse(fireStationServiceImpl.getFirefighters(pageNum, pageSize, fireStationDto));
    }


    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "微型消防站列表全部数据查询", notes = "微型消防站列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireStationDto>> selectForList(String bizOrgCode) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryForFireStationList(false,null,null,bizOrgCode));
    }

    /**
     * 查询机场单位
     *
     * @return
     * @throws Exception
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/company/listTree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询机场单位树", notes = "查询机场单位树")
    public ResponseModel<List<MenuFrom>> listCompanyTree() throws Exception {
        List<MenuFrom> menus = fireStationServiceImpl.getCompanyTeamTree();
        return ResponseHelper.buildResponse(menus);
    }

    /**
     * 微型消防站单位部门树
     *
     * @param
     * @return
     */
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/tree/companyTreeByUserAndType")
    @ApiOperation(httpMethod = "GET", value = "微型消防站单位树", notes = "微型消防站单位树")
    public ResponseModel<List<OrgMenuDto>> companyTreeByUserAndType() {
        // 获取登陆人角色
        ReginParams reginParams = getSelectedOrgInfo();
        // 权限赋值
        PermissionInterceptorContext.setDataAuthRule(authKey);
        return ResponseHelper.buildResponse(iOrgUsrService.companyTreeByUserAndType(reginParams, OrgPersonEnum.公司.getKey()));
    }
    @PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/fireStationCountAndBuildingTree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人角色获取当前单位下的所在建筑的微型消防站统计值", notes = "根据登录人角色获取当前单位下的所在建筑的微型消防站统计值")
	public ResponseModel<List<Map<String, Object>>> fireStationCountAndBuildingTree(
			@RequestParam(required = false) String bizOrgCode) {
		return ResponseHelper.buildResponse(fireStationServiceImpl.fireStationCountAndBuildingTree(bizOrgCode));
	}
}
