package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 改造变更登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgChangeRegistrationReformDto", description = "改造变更登记")
public class JgChangeRegistrationReformDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "办理状态")
    private String auditStatus;

    @ApiModelProperty(value = "登记机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "检验单位")
    private String inspectUnitName;

    @ApiModelProperty(value = "检验结果照片")
    private String inspectResultPhoto;

    @ApiModelProperty(value = "检验结果")
    private String inspectResult;

    @ApiModelProperty(value = "终审通过时间")
    private Date auditPassDate;

    @ApiModelProperty(value = "登记类别")
    private String regType;

    @ApiModelProperty(value = "注册登记日期")
    private Date regDate;

    @ApiModelProperty(value = "列表搜索，申请日期")
    private String applicationDate;

    @ApiModelProperty(value = "注册登记人员ID")
    private String regPersonId;

    @ApiModelProperty(value = "注册登记人员")
    private String regPersonName;

    @ApiModelProperty(value = "安装单位名称")
    private String installUnitName;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "录入单位统一信用代码")
    private String inputUnitNo;

    @ApiModelProperty(value = "使用登记编号")
    private String useRegistrationCode;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "检验机构统一信用代码")
    private String inspectUnitCreditCode;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "登记机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "登记机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty(value = "改造告知申请id")
    private String reformNoticeId;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    private List<String> roleIds;

    private String dataType;

    private String unitCode;

    private String nextTaskId;

    private String createUserName;

    private String createUserCompanyName;

    private String equipListName;

    private String nextExecuteUserIds;

    @ApiModelProperty (value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty (value = "设备种类")
    private String equList;

    @ApiModelProperty (value = "设备类别")
    private String equCategory;

    @ApiModelProperty (value = "设备品种")
    private String equDefine;

    @ApiModelProperty (value = "设备代码")
    private String equCode;

    @ApiModelProperty (value = "code96333")
    private String code96333;

    @ApiModelProperty (value = "设备地址")
    private String equAddress;

}
