package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZLStatisticsMapper;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Service
public class ZLDPStatisticsServiceImpl {

    @Resource
    private ZLStatisticsMapper screenMapper;

    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;

    @Autowired
    RestHighLevelClient restHighLevelClient;
    private static Map<String, String> regionCodeOrgCodeMap = new ConcurrentHashMap<>();


    public List<Map<String, Object>> companyInfo(DPFilterParamDto screenDto) {

        List<Map<String, Object>> list = screenMapper.getCompanyInfo(screenDto);
        List<Map<String, Object>> returnList = new ArrayList<>();

        //数据处理后Map，key为企业类型+设备，value为计数
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, Object> map : list) {
            JSONArray equipCategoryArray = (JSONArray) JSONArray.parse((String) map.get("equipCategory"));
            String[] UnitTypeArray = ((String) map.get("unitType")).split("#");
            for (int i = 0; i < UnitTypeArray.length; i++) {
                String unitTypeName = UnitTypeArray[i];
                for (int j = 0; j < equipCategoryArray.size(); j++) {
                    if (dataMap.containsKey(unitTypeName + equipCategoryArray.get(j))) {
                        dataMap.put(unitTypeName + equipCategoryArray.get(j), dataMap.get(unitTypeName + equipCategoryArray.get(j)) + 1);
                    } else {
                        dataMap.put(unitTypeName + equipCategoryArray.get(j), 1);
                    }
                }
            }
        }
        /**
         * 4000	起重机械
         * 3000	电梯
         * 5000	场（厂）内机动车辆
         * 1000	锅炉
         * 2000	压力容器
         * 6000	大型游乐设施（B类）
         * 9000	客运索道
         * 8000 压力管道
         */


        //充装Map
        Map<String, Object> chongzhuangMap = new HashMap<>();
        List<Map<String, Object>> chongzhuangCompanyList = new ArrayList<>();
        chongzhuangMap.put("key", "chongzhuangCompany");
        chongzhuangMap.put("value", "充装单位");
        //充装压力容器
        Map<String, Object> chongzhuangyalirongqiMap = new HashMap<>();
        chongzhuangyalirongqiMap.put("key", "key04");
        chongzhuangyalirongqiMap.put("name", "气瓶");
        chongzhuangyalirongqiMap.put("value", dataMap.getOrDefault("充装单位2000", 0));
        chongzhuangCompanyList.add(chongzhuangyalirongqiMap);
        chongzhuangMap.put("data", chongzhuangCompanyList);

        //安改维Map
        Map<String, Object> angaiweiMap = new HashMap<>();
        List<Map<String, Object>> angaiweiCompanyList = new ArrayList<>();
        angaiweiMap.put("key", "angaiweiCompany");
        angaiweiMap.put("value", "安改维单位");
        //安改维电梯
        Map<String, Object> angaiweidiantiMap = new HashMap<>();
        angaiweidiantiMap.put("key", "key01");
        angaiweidiantiMap.put("name", "电梯");
        angaiweidiantiMap.put("value", dataMap.getOrDefault("安装改造维修单位3000", 0));
        angaiweiCompanyList.add(angaiweidiantiMap);
        //安改维锅炉
        Map<String, Object> angaiweiguoluMap = new HashMap<>();
        angaiweiguoluMap.put("key", "key02");
        angaiweiguoluMap.put("name", "锅炉");
        angaiweiguoluMap.put("value", dataMap.getOrDefault("安装改造维修单位1000", 0));
        angaiweiCompanyList.add(angaiweiguoluMap);
        //安改维场内机动车
        Map<String, Object> angaiweijidongcheMap = new HashMap<>();
        angaiweijidongcheMap.put("key", "key03");
        angaiweijidongcheMap.put("name", "场内机动车");
        angaiweijidongcheMap.put("value", dataMap.getOrDefault("安装改造维修单位5000", 0));
        angaiweiCompanyList.add(angaiweijidongcheMap);
        //安改维压力管道
        Map<String, Object> angaiweiyaliguandaoMap = new HashMap<>();
        angaiweiyaliguandaoMap.put("key", "key05");
        angaiweiyaliguandaoMap.put("name", "压力管道");
        angaiweiyaliguandaoMap.put("value", dataMap.getOrDefault("安装改造维修单位9000", 0));
        angaiweiCompanyList.add(angaiweiyaliguandaoMap);
        //安改维起重机械
        Map<String, Object> angaiweiqizhongjixieMap = new HashMap<>();
        angaiweiqizhongjixieMap.put("key", "key06");
        angaiweiqizhongjixieMap.put("name", "起重机械");
        angaiweiqizhongjixieMap.put("value", dataMap.getOrDefault("安装改造维修单位4000", 0));
        angaiweiCompanyList.add(angaiweiqizhongjixieMap);
        //安改维游乐设施
        Map<String, Object> angaiweiyoulesheshiMap = new HashMap<>();
        angaiweiyoulesheshiMap.put("key", "key07");
        angaiweiyoulesheshiMap.put("name", "大型游乐设施");
        angaiweiyoulesheshiMap.put("value", dataMap.getOrDefault("安装改造维修单位6000", 0));
        angaiweiCompanyList.add(angaiweiyoulesheshiMap);
        //安改维客运索道
        Map<String, Object> angaiweikeyunsuodaoMap = new HashMap<>();
        angaiweikeyunsuodaoMap.put("key", "key08");
        angaiweikeyunsuodaoMap.put("name", "客运索道");
        angaiweikeyunsuodaoMap.put("value", dataMap.getOrDefault("安装改造维修单位9000", 0));
        angaiweiCompanyList.add(angaiweikeyunsuodaoMap);
        angaiweiMap.put("data", angaiweiCompanyList);

        //设计Map
        Map<String, Object> shejiMap = new HashMap<>();
        List<Map<String, Object>> shejiCompanyList = new ArrayList<>();
        shejiMap.put("key", "shejiCompany");
        shejiMap.put("value", "设计单位");
        //设计压力容器
        Map<String, Object> shejiyalirongqiMap = new HashMap<>();
        shejiyalirongqiMap.put("key", "key04");
        shejiyalirongqiMap.put("name", "压力容器");
        shejiyalirongqiMap.put("value", dataMap.getOrDefault("设计单位2000", 0));
        shejiCompanyList.add(shejiyalirongqiMap);
        //设计压力管道
        Map<String, Object> shejiyaliguandaoMap = new HashMap<>();
        shejiyaliguandaoMap.put("key", "key05");
        shejiyaliguandaoMap.put("name", "压力管道");
        shejiyaliguandaoMap.put("value", dataMap.getOrDefault("设计单位8000", 0));
        shejiCompanyList.add(shejiyaliguandaoMap);
        shejiMap.put("data", shejiCompanyList);

        //制造Map
        Map<String, Object> zhizaoMap = new HashMap<>();
        List<Map<String, Object>> zhizaoCompanyList = new ArrayList<>();
        zhizaoMap.put("key", "zhizaoCompany");
        zhizaoMap.put("value", "制造单位");
        //制造电梯
        Map<String, Object> zhizaodiantiMap = new HashMap<>();
        zhizaodiantiMap.put("key", "key01");
        zhizaodiantiMap.put("name", "电梯");
        zhizaodiantiMap.put("value", dataMap.getOrDefault("制造单位3000", 0));
        zhizaoCompanyList.add(zhizaodiantiMap);
        //制造锅炉
        Map<String, Object> zhizaoguoluMap = new HashMap<>();
        zhizaoguoluMap.put("key", "key02");
        zhizaoguoluMap.put("name", "锅炉");
        zhizaoguoluMap.put("value", dataMap.getOrDefault("制造单位1000", 0));
        zhizaoCompanyList.add(zhizaoguoluMap);
        //制造锅炉
        Map<String, Object> zhizaojidongcheMap = new HashMap<>();
        zhizaojidongcheMap.put("key", "key03");
        zhizaojidongcheMap.put("name", "场内机动车");
        zhizaojidongcheMap.put("value", dataMap.getOrDefault("制造单位5000", 0));
        zhizaoCompanyList.add(zhizaojidongcheMap);
        //制造压力容器
        Map<String, Object> zhizaoyalirongqiMap = new HashMap<>();
        zhizaoyalirongqiMap.put("key", "key04");
        zhizaoyalirongqiMap.put("name", "压力容器");
        zhizaoyalirongqiMap.put("value", dataMap.getOrDefault("制造单位2000", 0));
        zhizaoCompanyList.add(zhizaoyalirongqiMap);
        //制造起重机械
        Map<String, Object> zhizaoqizhongjixieMap = new HashMap<>();
        zhizaoqizhongjixieMap.put("key", "key06");
        zhizaoqizhongjixieMap.put("name", "起重机械");
        zhizaoqizhongjixieMap.put("value", dataMap.getOrDefault("制造单位4000", 0));
        zhizaoCompanyList.add(zhizaoqizhongjixieMap);
        //制造游乐设施
        Map<String, Object> zhizaoyoulesheshiMap = new HashMap<>();
        zhizaoyoulesheshiMap.put("key", "key07");
        zhizaoyoulesheshiMap.put("name", "大型游乐设施");
        zhizaoyoulesheshiMap.put("value", dataMap.getOrDefault("制造单位6000", 0));
        zhizaoCompanyList.add(zhizaoyoulesheshiMap);
        //制造客运索道
        Map<String, Object> zhizaokeyunsuodaoMap = new HashMap<>();
        zhizaokeyunsuodaoMap.put("key", "key08");
        zhizaokeyunsuodaoMap.put("name", "客运索道");
        zhizaokeyunsuodaoMap.put("value", dataMap.getOrDefault("制造单位9000", 0));
        zhizaoCompanyList.add(zhizaokeyunsuodaoMap);
        zhizaoMap.put("data", zhizaoCompanyList);

        //使用Map
        Map<String, Object> shiyongMap = new HashMap<>();
        List<Map<String, Object>> shiyongCompanyList = new ArrayList<>();
        shiyongMap.put("key", "shiyongCompany");
        shiyongMap.put("value", "使用单位");
        //使用电梯
        Map<String, Object> shiyongdiantiMap = new HashMap<>();
        shiyongdiantiMap.put("key", "key01");
        shiyongdiantiMap.put("name", "电梯");
        shiyongdiantiMap.put("value", dataMap.getOrDefault("使用单位3000", 0));
        shiyongCompanyList.add(shiyongdiantiMap);
        //使用锅炉
        Map<String, Object> shiyongguoluMap = new HashMap<>();
        shiyongguoluMap.put("key", "key02");
        shiyongguoluMap.put("name", "锅炉");
        shiyongguoluMap.put("value", dataMap.getOrDefault("使用单位1000", 0));
        shiyongCompanyList.add(shiyongguoluMap);
        //使用锅炉
        Map<String, Object> shiyongjidongcheMap = new HashMap<>();
        shiyongjidongcheMap.put("key", "key03");
        shiyongjidongcheMap.put("name", "场内机动车");
        shiyongjidongcheMap.put("value", dataMap.getOrDefault("使用单位5000", 0));
        shiyongCompanyList.add(shiyongjidongcheMap);
        //使用压力容器
        Map<String, Object> shiyongyalirongqiMap = new HashMap<>();
        shiyongyalirongqiMap.put("key", "key04");
        shiyongyalirongqiMap.put("name", "压力容器");
        shiyongyalirongqiMap.put("value", dataMap.getOrDefault("使用单位2000", 0));
        shiyongCompanyList.add(shiyongyalirongqiMap);
        //使用压力管道
        Map<String, Object> shiyongyaliguandaoMap = new HashMap<>();
        shiyongyaliguandaoMap.put("key", "key05");
        shiyongyaliguandaoMap.put("name", "压力管道");
        shiyongyaliguandaoMap.put("value", dataMap.getOrDefault("使用单位9000", 0));
        shiyongCompanyList.add(shiyongyaliguandaoMap);
        //使用起重机械
        Map<String, Object> shiyongqizhongjixieMap = new HashMap<>();
        shiyongqizhongjixieMap.put("key", "key06");
        shiyongqizhongjixieMap.put("name", "起重机械");
        shiyongqizhongjixieMap.put("value", dataMap.getOrDefault("使用单位4000", 0));
        shiyongCompanyList.add(shiyongqizhongjixieMap);
        //使用游乐设施
        Map<String, Object> shiyongyoulesheshiMap = new HashMap<>();
        shiyongyoulesheshiMap.put("key", "key07");
        shiyongyoulesheshiMap.put("name", "大型游乐设施");
        shiyongyoulesheshiMap.put("value", dataMap.getOrDefault("使用单位6000", 0));
        shiyongCompanyList.add(shiyongyoulesheshiMap);
        //使用客运索道
        Map<String, Object> shiyongkeyunsuodaoMap = new HashMap<>();
        shiyongkeyunsuodaoMap.put("key", "key08");
        shiyongkeyunsuodaoMap.put("name", "客运索道");
        shiyongkeyunsuodaoMap.put("value", dataMap.getOrDefault("使用单位9000", 0));
        shiyongCompanyList.add(shiyongkeyunsuodaoMap);
        shiyongMap.put("data", shiyongCompanyList);

        returnList.add(zhizaoMap);
        returnList.add(angaiweiMap);
        returnList.add(shiyongMap);
        returnList.add(shejiMap);
        returnList.add(chongzhuangMap);

        return returnList;
    }

    public List<Map<String, Object>> testOrg(DPFilterParamDto screenDto) {
        List<Map<String, Object>> list = screenMapper.testOrg(screenDto);
        List<Map<String, Object>> returnList = new ArrayList<>();
        Map<String, Object> dataMap = new HashMap<>();
        for (int i = 0; i < list.size(); i++) {
            dataMap.put((String) list.get(i).get("agencyType"), list.get(i).get("count"));
        }
        /**
         * 1	甲类检验机构A1级
         * 2	甲类检验机构A2级
         * 4	甲类检验机构B1级
         * 5	甲类检验机构B2级
         * 6	乙类检验机构
         * 7	丙类检验机构
         * 8	检测机构
         * 9	综合检验机构甲类（旧规）
         * 10	综合检验机构乙类（旧规）
         * 11	综合检验机构丙类（旧规）
         * 12	自检机构（旧规）
         * 13	气瓶检验机构（旧规）
         * 14	无损检测机构（旧规）
         */
        Map<String, Object> newMap = new HashMap<>();
        newMap.put("key", "new");
        newMap.put("name", "新分类");
        List<Map<String, Object>> newList = new ArrayList<>();
        Map<String, Object> newMap1 = new HashMap<>();
        newMap1.put("name", "甲类检验机构A1级");
        newMap1.put("value", dataMap.getOrDefault("1", 0));
        newList.add(newMap1);
        Map<String, Object> newMap2 = new HashMap<>();
        newMap2.put("name", "甲类检验机构A2级");
        newMap2.put("value", dataMap.getOrDefault("2", 0));
        newList.add(newMap2);
        Map<String, Object> newMap3 = new HashMap<>();
        newMap3.put("name", "甲类检验机构B1级");
        newMap3.put("value", dataMap.getOrDefault("4", 0));
        newList.add(newMap3);
        Map<String, Object> newMap4 = new HashMap<>();
        newMap4.put("name", "甲类检验机构B2级");
        newMap4.put("value", dataMap.getOrDefault("5", 0));
        newList.add(newMap4);
        Map<String, Object> newMap5 = new HashMap<>();
        newMap5.put("name", "乙类检验机构");
        newMap5.put("value", dataMap.getOrDefault("6", 0));
        newList.add(newMap5);
        Map<String, Object> newMap6 = new HashMap<>();
        newMap6.put("name", "丙类检验机构");
        newMap6.put("value", dataMap.getOrDefault("7", 0));
        newList.add(newMap6);
        Map<String, Object> newMap7 = new HashMap<>();
        newMap7.put("name", "检测机构");
        newMap7.put("value", dataMap.getOrDefault("8", 0));
        newList.add(newMap7);
        newMap.put("data", newList);
        Map<String, Object> oldMap = new HashMap<>();
        oldMap.put("key", "old");
        oldMap.put("name", "旧分类");
        List<Map<String, Object>> oldList = new ArrayList<>();
        Map<String, Object> oldMap1 = new HashMap<>();
        oldMap1.put("name", "综合检验机构甲类（旧规）");
        oldMap1.put("value", dataMap.getOrDefault("9", 0));
        oldList.add(oldMap1);
        Map<String, Object> oldMap2 = new HashMap<>();
        oldMap2.put("name", "综合检验机构乙类（旧规）");
        oldMap2.put("value", dataMap.getOrDefault("10", 0));
        oldList.add(oldMap2);
        Map<String, Object> oldMap3 = new HashMap<>();
        oldMap3.put("name", "综合检验机构丙类（旧规）");
        oldMap3.put("value", dataMap.getOrDefault("11", 0));
        oldList.add(oldMap3);
        Map<String, Object> oldMap4 = new HashMap<>();
        oldMap4.put("name", "自检机构（旧规）");
        oldMap4.put("value", dataMap.getOrDefault("12", 0));
        oldList.add(oldMap4);
        Map<String, Object> oldMap5 = new HashMap<>();
        oldMap5.put("name", "气瓶检验机构（旧规）");
        oldMap5.put("value", dataMap.getOrDefault("13", 0));
        oldList.add(oldMap5);
        Map<String, Object> oldMap6 = new HashMap<>();
        oldMap6.put("name", "无损检测机构（旧规）");
        oldMap6.put("value", dataMap.getOrDefault("14", 0));
        oldList.add(oldMap6);
        oldMap.put("data", oldList);
        returnList.add(newMap);
        returnList.add(oldMap);
        return returnList;
    }


    public Map<String, Object> userCount(DPFilterParamDto screenDto) {
        List<Map<String, String>> list = screenMapper.userCount(screenDto);
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, String> map : list) {
            String[] split = map.get("unitType").split("#");
            for (int i = 0; i < split.length; i++) {
                if (dataMap.containsKey(split[i])) {
                    dataMap.put(split[i], dataMap.get(split[i]) + 1);
                } else {
                    dataMap.put(split[i], 1);
                }
            }
        }
        List<String> xlist = Arrays.asList("制造单位", "安改维单位", "使用单位", "设计单位", "充装单位");
        List<Integer> ylist = new ArrayList();
        xlist.stream().forEach(x -> {
            ylist.add(dataMap.getOrDefault(x, 0));
        });
        Map<String, Object> returnMap = new HashMap<>();
        returnMap.put("xdata", xlist);
        returnMap.put("ydata", ylist);
        return returnMap;
    }


    public Map<String, Object> supervisorCount(DPFilterParamDto screenDto) {
        List<Map<String, Object>> list = screenMapper.supervisorCount(screenDto);
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, Object> map : list) {
            dataMap.put((String) map.get("industrySupervisor"), Integer.valueOf(map.get("count").toString()));
        }

        List<DataDictionary> dataDictionaryList = iDataDictionaryService.getByType("HYZGBM");
        List<String> xlist = dataDictionaryList.stream().map(DataDictionary::getName).collect(Collectors.toList());
        List<Object> ylist = new ArrayList();
        dataDictionaryList.stream().forEach(x -> {
            ylist.add(dataMap.getOrDefault(x.getCode(), 0));
        });
        Map<String, Object> returnMap = new HashMap<>();
        returnMap.put("xdata", xlist);
        returnMap.put("ydata", ylist);
        return returnMap;
    }


    public List<Map<String, Object>> equipmentInformCount(DPFilterParamDto screenDto) {
        SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //设置模糊搜索
        String orgCode = getAndSetOrgCode(screenDto.getCityCode());
        searchSourceBuilder.query(QueryBuilders.boolQuery()
                .must(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(orgCode) + "*")));
        searchSourceBuilder.aggregation(
                AggregationBuilders.terms("USE_SITE_CODE").field("USE_SITE_CODE")
        );
        searchRequest.source(searchSourceBuilder);
        Map<String, Integer> dataMap = new HashMap<>();
        List<Map<String, Object>> returnList = new ArrayList<>();
        try {
            // 执行搜索请求
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            // 获取所有聚合结果
            Aggregations aggregations = searchResponse.getAggregations();
            Terms termsResult = aggregations.get("USE_SITE_CODE");

            for (Terms.Bucket bucket : termsResult.getBuckets()) {
                String category = bucket.getKeyAsString(); // 或者使用 bucket.getKey() 对于非字符串类型
                long docCount = bucket.getDocCount();
                dataMap.put(category, (int) docCount);
            }
            List<DataDictionary> dataDictionaryList = iDataDictionaryService.getByType("ADDRESS");
            dataDictionaryList.stream().forEach(x -> {
                Map<String, Object> map = new HashMap<>();
                map.put(x.getName(), dataMap.getOrDefault(x.getCode(), 0));
                returnList.add(map);
            });
            Map<String, Object> otherMap = new HashMap<>();
            otherMap.put("其他", dataMap.getOrDefault("其他", 0) + dataMap.getOrDefault("", 0));
            returnList.add(otherMap);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return returnList;
    }

    private String getAndSetOrgCode(String cityCode) {
        String orgCode = regionCodeOrgCodeMap.get(cityCode);
        if (orgCode == null) {
            orgCode = screenMapper.getOrgCodeByCompanyCode(cityCode);
            if (orgCode != null) {
                regionCodeOrgCodeMap.put(cityCode, orgCode);
            }
        }
        return orgCode;
    }
}
