package com.yeejoin.amos.boot.module.tzs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 救援过程表
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_rescue_process")
public class RescueProcess extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 警情id
     */
	@TableField("alert_id")
    private Long alertId;

    /**
     * 是否派遣
     */
	@TableField("dispatch_status")
    private Boolean dispatchStatus;

    /**
     * 派遣时间
     */
	@TableField("dispatch_time")
    private Date dispatchTime;

    /**
     * 派遣人id
     */
	@TableField("dispatch_user_id")
    private String dispatchUserId;

    /**
     * 派遣人名称
     */
	@TableField("dispatch_user_name")
    private String dispatchUserName;

    /**
     * 是否到达
     */
	@TableField("arrive_status")
    private Boolean arriveStatus;

    /**
     * 到达时间
     */
	@TableField("arrive_time")
    private Date arriveTime;

    /**
     * 到达记录人id
     */
	@TableField("arrive_user_id")
    private String arriveUserId;

    /**
     * 到达记录人名称
     */
	@TableField("arrive_user_name")
    private String arriveUserName;

    /**
     * 到达反馈方式
     */
	@TableField("arrive_feedback_type")
    private String arriveFeedbackType;

    /**
     * 是否伤亡
     */
	@TableField("casualties_status")
    private Boolean casualtiesStatus;

    /**
     * 伤亡情况
     */
	@TableField("casualties_info")
    private String casualtiesInfo;

    /**
     * 是否救援成功
     */
	@TableField("rescue_status")
    private Boolean rescueStatus;

    /**
     * 救援完成时间
     */
	@TableField("rescue_time")
    private Date rescueTime;

    /**
     * 救援记录人id
     */
	@TableField("rescue_user_id")
    private String rescueUserId;

    /**
     * 救援记录人名称
     */
	@TableField("rescue_user_name")
    private String rescueUserName;

    /**
     * 救援反馈方式
     */
	@TableField("rescue_feedback_type")
    private String rescueFeedbackType;

    /**
     * 是否超时
     */
	@TableField("is_timeout")
    private Boolean isTimeout;

    /**
     * 到达反馈方式code
     */
	@TableField("arrive_feedback_code")
    private String arriveFeedbackCode;

    /**
     * 救援反馈方式code
     */
	@TableField("rescue_feedback_code")
    private String rescueFeedbackCode;

}
