package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.changeRegistrationTransfer;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationTransfer;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationTransferEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class ChangeRegistrationTransferEditUpdateService {

    private final JgChangeRegistrationTransferServiceImpl mainService;

    private final JgChangeRegistrationTransferEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgChangeRegistrationTransfer changeRegistrationTransfer = mainService.getOne(new LambdaQueryWrapper<JgChangeRegistrationTransfer>().eq(JgChangeRegistrationTransfer::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgChangeRegistrationTransferEq> eqs = eqService.list(new LambdaQueryWrapper<JgChangeRegistrationTransferEq>().eq(JgChangeRegistrationTransferEq::getEquipTransferId, changeRegistrationTransfer.getSequenceNbr()).select(JgChangeRegistrationTransferEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgChangeRegistrationTransferEq::getEquId).collect(Collectors.toSet());
    }

    public JgChangeRegistrationTransfer getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgChangeRegistrationTransfer>().eq(JgChangeRegistrationTransfer::getApplyNo, applyNo));
    }

}