package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentCategoryEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.Map;

@Service
public class CodeGenServiceImpl {


    private final EquipmentCategoryMapper equipmentCategoryMapper;


    // 西安行政区划code
    private static final String XIAN = "610100";
    // 咸阳行政区划code
    private static final String XIAN_YANG = "610400";

    public CodeGenServiceImpl(EquipmentCategoryMapper equipmentCategoryMapper) {
        this.equipmentCategoryMapper = equipmentCategoryMapper;
    }

    public String getSupervisorCodePrefix(String isNotXiXian, String city, String county) {
        String division;
        if (((XIAN.equals(city) || XIAN_YANG.equals(city)) && "1".equals(isNotXiXian))) {
            division = "X";
        } else {
            // 生成监管码前缀
            Map<String, Object> divisionMap = equipmentCategoryMapper.getAdministrativeDivision(EquipmentCategoryEnum.XZQH.getCode(), county);
            division = ObjectUtils.isEmpty(divisionMap) ? equipmentCategoryMapper.getAdministrativeDivision(EquipmentCategoryEnum.XZQH.getCode(), city).get("code").toString() : divisionMap.get("code").toString();
        }
        return division;
    }
}
