package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.elevator.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.elevator.api.mapper.RescueStationMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IRescueStationService;
import com.yeejoin.amos.boot.module.elevator.api.vo.RescueStationImportVo;
import com.yeejoin.amos.boot.module.elevator.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
*  服务实现类
*
* @author tb
* @date 2021-06-01
*/
@Service
public class RescueStationServiceImpl extends BaseService<RescueStationDto, RescueStation, RescueStationMapper> implements IRescueStationService {

    @Autowired
    RescueStationMapper rescueStationMapper;
    @Autowired
    IRescueStationService iRescueStationService;

    @Override
    public List<RescueStationDto> getListByLatLonDistance(String lat, String lon, Integer distance) {
        return rescueStationMapper.getListByLatLonDistance(lat,lon,distance);
    }

    @Override
    public List<RescueStationDto> selectExportData(String exportId) {
        List<String> ids = null;
        if(StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        return baseMapper.selectExportData(ids);
    }

    @Override
    public IPage<RescueStation> getRescueStationList(IPage<RescueStation> page,RescueStationDto dto) {
        return rescueStationMapper.getRescueStationList(page,dto);
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public ResponseModel<Object> expertDataImport(MultipartFile file, AgencyUserModel userModel) {
        try {
            InputStream inputStream = file.getInputStream();
            ExcelReader excelReader = EasyExcel.read(inputStream).build();
            List<ReadSheet> sheetList = excelReader.excelExecutor().sheetList();

            ReadSheet sheet = sheetList.get(0);
            if (ValidationUtil.isEmpty(sheet)) {
                throw new BadRequest("Excel导入模板有误，请重写下载导入！");
            }

            ArrayList<RescueStation> dataList = new ArrayList<>();

            EasyExcel.read(file.getInputStream(), RescueStationImportVo.class, new AnalysisEventListener<RescueStationImportVo>() {
                @Override
                public void invoke(RescueStationImportVo data, AnalysisContext context) {
                    RescueStation rescueStation = JSON.parseObject(JSON.toJSONString(data), RescueStation.class);
                    rescueStation.setIsDelete(Boolean.FALSE);
                    rescueStation.setRecDate(new Date());
                    rescueStation.setRecUserName(userModel.getUserName());
                    rescueStation.setRecUserId(userModel.getUserId());
                    dataList.add(rescueStation);
                }

                @Override
                public void doAfterAllAnalysed(AnalysisContext context) {
                }
            }).headRowNumber(1).sheet().doRead();

            excelReader.finish();

            // 保存数据
            this.saveOrUpdateBatch(dataList);

            return ResponseHelper.buildResponse("success");
        } catch (Exception e) {
            throw new BadRequest(e.getMessage());
        }
    }


    public Boolean saveRescueStation(RescueStationDto rescueStationDto){
        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        rescueStation.setRecUserId(RequestContext.getExeUserId());
        rescueStation.setRecDate(new Date());
        boolean save =false;
        LambdaQueryWrapper<RescueStation> wrapper = new LambdaQueryWrapper<>();
        if (!ValidationUtil.isEmpty(rescueStation)) {
            wrapper.eq(!ValidationUtil.isEmpty(rescueStation.getName()),RescueStation::getName,rescueStation.getName())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getCity()),RescueStation::getCity,rescueStation.getCity())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getDistrict()),RescueStation::getDistrict,rescueStation.getDistrict())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAffiliatedUnit()),RescueStation::getAffiliatedUnit,rescueStation.getAffiliatedUnit())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAddress()),RescueStation::getAddress,rescueStation.getAddress())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAffiliatedUnitId()),RescueStation::getAffiliatedUnitId,rescueStation.getAffiliatedUnitId())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getLatitude()),RescueStation::getLatitude,rescueStation.getLatitude())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getLongitude()),RescueStation::getLongitude,rescueStation.getLongitude())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getPrincipal()),RescueStation::getPrincipal,rescueStation.getPrincipal())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getPrincipalPhone()),RescueStation::getPrincipalPhone,rescueStation.getPrincipalPhone())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getProvince()),RescueStation::getProvince,rescueStation.getProvince())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRegionCode()),RescueStation::getRegionCode,rescueStation.getRegionCode())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRescueLeader()),RescueStation::getRescueLeader,rescueStation.getRescueLeader())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRescueLeaderPhone()),RescueStation::getRescueLeaderPhone,rescueStation.getRescueLeaderPhone());
            List<RescueStation> rescueStations = rescueStationMapper.selectList(wrapper);
            if (ValidationUtil.isEmpty(rescueStations) ) {
                save = iRescueStationService.save(rescueStation);
            }

        }
        return save;
    }
}
