package com.yeejoin.amos.boot.module.ys.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 救援案例管理
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="YsEmergencyCaseDto", description="救援案例管理")
public class YsEmergencyCaseDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "案例名称")
    private String caseName;

    @ApiModelProperty(value = "处置对象")
    private String handleObject;

    @ApiModelProperty(value = "灾情发生地市")
    private String cityDisaster;

    @ApiModelProperty(value = "灾情发生省份")
    private String provinceDisaster;

    @ApiModelProperty(value = "群众伤亡情况")
    private String personCasualties;

    @ApiModelProperty(value = "灾情等级id")
    private Integer disasterLevelId;

    @ApiModelProperty(value = "灾情大类型id")
    private Integer disasterTypeId;

    @ApiModelProperty(value = "灾情结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date disasterEndTime;

    @ApiModelProperty(value = "灾情开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date disasterStartTime;

    @ApiModelProperty(value = "灾情细分类型id")
    private Integer disasterSubdivideId;

    @ApiModelProperty(value = "视频信息")
    private JSONArray videoInfo;
    @ApiModelProperty(value = "图片信息")
    private JSONArray picInfo;

    @ApiModelProperty(value = "文档信息")
    private JSONArray fileInfo;

    @ApiModelProperty(value = "音频信息")
    @TableField("Audio_info")
    private JSONArray audioInfo;

    @ApiModelProperty(value = "立案时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date filingTime;

    @ApiModelProperty(value = "灾情发生地点")
    private String locationDisaster;

    @ApiModelProperty(value = "灾情类型")
    private String disasterType;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

}
