package com.yeejoin.amos.api.openapi.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.service.OpenapiBizTokenService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 * <pre>
 *  企业数据对接票据管理
 * </pre>
 *
 * @author gwb
 * @version $Id: InspectionController.java, v 0.1 2021年11月8日 下午6:47:54 gwb Exp $
 */
@RestController
@RequestMapping(value = "/bizToken")
@Api(tags = "bizToken-企业数据对接票据管理")
public class OpenapiBizTokenController
{
	private static final  Logger logger = LogManager.getLogger(OpenapiBizTokenController.class);
	
	@Autowired
	private OpenapiBizTokenService openapiBizTokenService;
	
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "申请登录令牌")
	@GetMapping(value = "/applyToken")
	public ResponseModel<String> applyToken (
			@RequestParam String appId) throws Exception 
	{
		logger.info("appId信息：",appId);
		String appToken = openapiBizTokenService.getByAppId(appId);
		logger.info("appToken信息：",appToken);		
		return ResponseHelper.buildResponse(appToken);
	}
	
//	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
//	@ApiOperation(value = "获取APPID")
//	@GetMapping(value = "/getAppId")
//	public ResponseModel<String> getAppId (
//			@RequestParam String companyCode) throws Exception 
//	{
//		String appId = DesUtil.encode(companyCode, Constant.SECRETKEY);
//		logger.info("appId信息：",appId);
//		return ResponseHelper.buildResponse(appId);
//	}
//	
}
