package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.YJDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.AlertUseUnitStatisticsDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertPaperInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "大屏-应急-统计API")
@RequestMapping("/dp/yj")
public class YJDPStatisticsController {


    private YJDPStatisticsServiceImpl statisticsService;

    public YJDPStatisticsController(YJDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-办理量 (近7日)", notes = "大屏-应急-办理量 (近7日)")
    @PostMapping(value = "/eventStatByDay")
    public ResponseModel<JSONObject> eventStatByDay(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByDay(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-电梯数量统计 (按区域)", notes = "大屏-应急-电梯数量统计 (按区域)")
    @PostMapping(value = "/elevatorCountStat")
    public ResponseModel<JSONObject> elevatorCountStat(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.elevatorCountStat(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-事件分布 (按场所)", notes = "大屏-应急-事件分布 (按场所)")
    @PostMapping(value = "/eventStatByLocation")
    public ResponseModel<JSONObject> eventStatByLocation(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.eventStatByLocation(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-故障原因占比", notes = "大屏-应急-故障原因占比")
    @PostMapping(value = "/faultCauseRatio")
    public ResponseModel<JSONObject> faultCauseRatio(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.faultCauseRatio(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-困人救援月度情况", notes = "大屏-应急-困人救援月度情况")
    @PostMapping(value = "/trappedUserCount")
    public ResponseModel<JSONObject> trappedUserCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-即时警情列表", notes = "大屏-应急-即时警情列表")
    @PostMapping(value = "/instantAlert")
    public ResponseModel<List<AlertPaperInfoDto>> instantAlert(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.instantAlert(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-月度困人故障高发使用单位（默认上月度）", notes = "大屏-应急-月度困人故障高发使用单位")
    @PostMapping(value = "/trappedUserHighCompanyCount")
    public ResponseModel<List<AlertUseUnitStatisticsDto>> trappedUserHighCompanyCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.trappedUserHighCompanyCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-维保单位平均救援时间排名", notes = "大屏-应急-维保单位平均救援时间排名")
    @PostMapping(value = "/rankUnitByRescueTime")
    public ResponseModel<List<Map<String, Object>>> rankUnitByRescueTime(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.rankUnitByRescueTime(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-各地市应急事件总数排名", notes = "大屏-应急-各地市应急事件总数排名")
    @PostMapping(value = "/regionEventRank")
    public ResponseModel<JSONObject> regionEventRank(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.regionEventRank(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图图列统计", notes = "大屏-应急-中间地图图列统计")
    @PostMapping(value = "/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-应急-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }
}
