package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.service.DocAuditService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * <p>
 * 知识库文档发布审核流程 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "docaudit")
@RequestMapping(value = "/v1/doccontent/docaudit")
@Api(tags = "knowledgebase-文档发布审核流程")
public class DocAuditResource {

    private final Logger logger = LogManager.getLogger(DocAuditResource.class);

    @Autowired
    private DocAuditService docAuditService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档发布")
    @RequestMapping(value = "/status/publish/{ids}", method = RequestMethod.PUT)
    public ResponseModel docPublish(@PathVariable(value = "ids") String ids) {
        return ResponseHelper.buildResponse(docAuditService.publish(StringUtil.String2LongList(ids)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档取消发布")
    @RequestMapping(value = "/status/unpublish/{ids}", method = RequestMethod.PUT)
    public ResponseModel docUnpublish(@PathVariable(value = "ids") String ids) {
        return ResponseHelper.buildResponse(docAuditService.unpublish(StringUtil.String2LongList(ids)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档提交")
    @RequestMapping(value = "/status/submit/{ids}", method = RequestMethod.PUT)
    public ResponseModel docSubmit(@PathVariable(value = "ids") String ids) {
        return ResponseHelper.buildResponse(docAuditService.submit(StringUtil.String2LongList(ids)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档审核-通过")
    @RequestMapping(value = "/status/pass/{ids}", method = RequestMethod.PUT)
    public ResponseModel docPass(@PathVariable(value = "ids") String ids) {
        return ResponseHelper.buildResponse(docAuditService.pass(StringUtil.String2LongList(ids)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档审核-驳回")
    @RequestMapping(value = "/status/reject/{id}", method = RequestMethod.PUT)
    public ResponseModel docReject(@PathVariable(value = "id") Long id,
                                   @RequestBody Map<String, Object> body) {
        String rejectionComment = body.containsKey("rejectionComment") ? body.get("rejectionComment").toString() : null;
        return ResponseHelper.buildResponse(docAuditService.reject(id, rejectionComment));
    }
}
