package com.yeejoin.amos.boot.biz.common.bo;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import lombok.Data;

import java.io.Serializable;

/***
 *
 * 用户选择保存实体类
 * @author Dell
 * **/
public class ReginParams implements Serializable {
    private static final long serialVersionUID = 1L;
    private CompanyBo company;
    private RoleBo role;
    private DepartmentBo department;
    private AgencyUserModel userModel;
    private PersonIdentity personIdentity;
    
    @Data
    public static class PersonIdentity implements Serializable {
        private String identityType;
        private String personSeq;
        private String personName;
        private String companyId;
        private String companyName;
        private String bizOrgCode;
        private String companyBizOrgCode;
    }

    public PersonIdentity getPersonIdentity() {
        return personIdentity;
    }

    public void setPersonIdentity(PersonIdentity personIdentity) {
        this.personIdentity = personIdentity;
    }

    @Deprecated
    private String token;

    public CompanyBo getCompany() {
        return company;
    }

    public void setCompany(CompanyBo company) {
        this.company = company;
    }

    public RoleBo getRole() {
        return role;
    }

    public void setRole(RoleBo role) {
        this.role = role;
    }

    public DepartmentBo getDepartment() {
        return department;
    }

    public void setDepartment(DepartmentBo department) {
        this.department = department;
    }

    public AgencyUserModel getUserModel() {
        return userModel;
    }

    public void setUserModel(AgencyUserModel userModel) {
        this.userModel = userModel;
    }

    @Deprecated
    public String getToken() {
        return token;
    }

    @Deprecated
    public void setToken(String token) {
        this.token = token;
    }
}
