package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.*;
import com.yeejoin.amos.api.openapi.face.orm.entity.*;
import com.yeejoin.amos.api.openapi.face.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * 监管业务数据对接
 *
 * @author Zhang Yingbin
 */
@RestController
@RequestMapping(value = "/openapijg/supervise")
@Api(tags = "Supervise-监管业务数据接入")
public class SuperviseController {

    @Autowired
    private DesignInfoService designInfoService;

    @Autowired
    private ProduceInfoService produceInfoService;

    @Autowired
    private ConstructionInfoService constructionInfoService;

    @Autowired
    private RegistrationInfoService registrationInfoService;

    @Autowired
    private UseInfoService useInfoService;

    @Autowired
    private MaintenanceInfoService maintenanceInfoService;

    @Autowired
    private SuperviseInfoService superviseInfoService;

    @Autowired
    private OtherInfoService otherInfoService;

    @Autowired
    private ElevatorTechInfoService evatorTechInfoService;

    @Autowired
    private EnclosureInfoService enclosureInfoService;

    @Autowired
    private EnterpriseInfoService enterpriseInfoService;

    @Autowired
    private StaffBaseInfoService staffBaseInfoService;

    @Autowired
    private StaffQualifInfoService staffQualifInfoService;

    @Autowired
    private InspectionInfoService inspectionInfoService;


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增设计信息")
    @PostMapping(value = "/designInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveDesignInfo (@RequestBody List<DesignInfoModel> designInfo) throws Exception
    {
        return ResponseHelper.buildResponse(designInfoService.saveDesignInfo(designInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增制造信息")
    @PostMapping(value = "/produceInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveProduceInfo (@RequestBody List<ProduceInfoModel> produceInfo) throws Exception
    {
        return ResponseHelper.buildResponse(produceInfoService.saveProduceInfo(produceInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增施工信息")
    @PostMapping(value = "/constructionInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveConstructionInfo (@RequestBody List<ConstructionInfo> constructionInfo) throws Exception
    {
        return ResponseHelper.buildResponse(constructionInfoService.saveConstructionInfo(constructionInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增注册等级信息")
    @PostMapping(value = "/registrationInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveRegistrationInfo (@RequestBody List<RegistrationInfoModel> registrationInfo) throws Exception
    {
        return ResponseHelper.buildResponse(registrationInfoService.saveRegistrationInfo(registrationInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增使用信息")
    @PostMapping(value = "/useInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveUseInfo (@RequestBody List<UseInfo> useInfo) throws Exception
    {
        return ResponseHelper.buildResponse(useInfoService.saveUseInfo(useInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增维保单位信息")
    @PostMapping(value = "/maintenanceInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveMaintenanceInfo (@RequestBody List<MaintenanceInfoModel> maintenanceInfo) throws Exception
    {
        return ResponseHelper.buildResponse(maintenanceInfoService.saveMaintenanceInfo(maintenanceInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增监督管理信息")
    @PostMapping(value = "/superviseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveSuperviseInfo (@RequestBody List<SuperviseInfo> superviseInfo) throws Exception
    {
        return ResponseHelper.buildResponse(superviseInfoService.saveSuperviseInfo(superviseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增其他信息")
    @PostMapping(value = "/otherInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveOtherInfo (@RequestBody List<OtherInfo> otherInfo) throws Exception
    {
        return ResponseHelper.buildResponse(otherInfoService.saveOtherInfo(otherInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增电梯技术参数")
    @PostMapping(value = "/elevatorTechInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveElevatorTechInfo (@RequestBody List<ElevatorTechInfoModel> elevatorTechInfo) throws Exception
    {
        return ResponseHelper.buildResponse(evatorTechInfoService.saveElevatorTechInfo(elevatorTechInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增特种设备附件资料信息")
    @PostMapping(value = "/enclosureInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveEnclosureInfo (@RequestBody List<EnclosureInfo> enclosureInfo) throws Exception
    {
        return ResponseHelper.buildResponse(enclosureInfoService.saveEnclosureInfo(enclosureInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增企业数据信息")
    @PostMapping(value = "/enterpriseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveEnterpriseInfo (@RequestBody List<EnterpriseInfoModel> enterpriseInfo) throws Exception
    {
        return ResponseHelper.buildResponse(enterpriseInfoService.saveEnterpriseInfo(enterpriseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增人员基本信息")
    @PostMapping(value = "/staffBaseInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveStaffBaseInfo (@RequestBody List<StaffBaseInfo> staffBaseInfo) throws Exception
    {
        return ResponseHelper.buildResponse(staffBaseInfoService.saveStaffBaseInfo(staffBaseInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "新增人员资质信息")
    @PostMapping(value = "/staffQualifInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveStaffQualifInfo (@RequestBody List<StaffQualifInfoModel> staffQualifInfo) throws Exception
    {
        return ResponseHelper.buildResponse(staffQualifInfoService.saveStaffQualifInfo(staffQualifInfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "特种设备检验信息")
    @PostMapping(value = "/inspectionInfo")
    @RestEventTrigger(value = "openapiLogEventHandler")
    public ResponseModel<String> saveInspectionInfo (@RequestBody List<InspectionInfoModel> inspectionInfo) throws Exception
    {
        return ResponseHelper.buildResponse(inspectionInfoService.saveInspectionInfo(inspectionInfo));
    }

}
