package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * <p>
 * 电梯故障表
 * </p>
 *
 * @author 子杨
 * @since 2021-09-28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tz_elevator_alarm")
public class ElevatorAlarm extends BaseEntity {


	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = -1519653642449280265L;

	/**
	 * 电梯注册码
	 */
	@TableField("register_code")
	private String registerCode;
	/**
	 * 电梯应急救援识别码
	 */
	@TableField("rescue_code")
	private Integer rescueCode;
	/**
	 * 所属省
	 */
	@TableField("province")
	private String province;
	/**
	 * 所属地市
	 */
	@TableField("city")
	private String city;
	/**
	 * 所属区县
	 */
	@TableField("district")
	private String district;
	/**
	 * 电梯地址
	 */
	@TableField("address")
	private String address;
	/**
	 * 设备类别
	 */
	@TableField("device_category")
	private String deviceCategory;
	/**
	 * 原始故障编号
	 */
	@TableField("fault_id")
	private String faultId;
	/**
	 * 故障发生时间
	 */
	@TableField("start_date")
	private Date startDate;
	/**
	 * 故障类型编码
	 */
	@TableField("type")
	private String type;
	/**
	 * 故障类型名称
	 */
	@TableField("type_name")
	private String typeName;
	/**
	 * 处置状态。0：处置完成。1：故障发生 2：发出通知 3：处置响应 4：处置到场 5：误报
	 */
	@TableField("deal_status")
	private Integer dealStatus;
	/**
	 * 处置时间
	 */
	@TableField("deal_date")
	private Date dealDate;
	/**
	 * 处置人
	 */
	@TableField("deal_person")
	private Integer dealPerson;
	/**
	 * 现场确认是否困人。0：不困人，1：困人
	 */
	@TableField("is_trap")
	private Integer isTrap;
	/**
	 * 是否自恢复 0：否1：是
	 */
	@TableField("selfrepair")
	private Integer selfrepair;
	/**
	 * 故障发生时的总接触器吸合或是断开。0：吸合，1：断开
	 */
	@TableField("deal_note")
	private Integer dealNote;
	/**
	 * 是否自恢复 0：否1：是
	 */
	@TableField("main_contactor")
	private Integer mainContactor;
	/**
	 * 故障发生时的运行接触器吸合或是断开。0：吸合，1：断开
	 */
	@TableField("run_contactor")
	private Integer runContactor;
	/**
	 * 故障发生时的安全回路是否断开 0：正常，1：断开
	 */
	@TableField("circuit")
	private Integer circuit;
	/**
	 * 故障发生时的轿厢运行状态。1：停止，2：运行
	 */
	@TableField("car_status")
	private Integer carStatus;
	/**
	 * 故障发生时的方向。1：无方向 2：上行 3：下行
	 */
	@TableField("direction")
	private Integer direction;
	/**
	 * 故障发生时的轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区
	 */
	@TableField("is_zone")
	private Integer isZone;
	/**
	 * 故障发生时的当前物理楼层
	 */
	@TableField("floor")
	private Integer floor;
	/**
	 * 故障发生时的关门到位 1：关门到位，0：无关门到位信号
	 */
	@TableField("door_status")
	private Integer doorStatus;
	/**
	 * 故障发生时的上极限是否动作 0:否，1：是
	 */
	@TableField("up_limit")
	private Integer upLimit;
	/**
	 * 故障发生时的下极限是否动作 0:否，1：是
	 */
	@TableField("down_limit")
	private Integer downLimit;
	/**
	 * 故障发生时的轿厢报警按钮是否动作 0:否，1：是
	 */
	@TableField("alarm")
	private Integer alarm;
	/**
	 * 累计运行小时数，保留到小数点后两位
	 */
	@TableField("hours")
	private Double hours;
	/**
	 * 累计运行次数
	 */
	@TableField("run_count")
	private Integer runCount;
	/**
	 * 操作人名称
	 */
	@TableField("rec_user_name")
	private String recUserName;
	/**
	 * 是否删除
	 */
	@TableField("is_delete")
	private Boolean isDelete;
}

